﻿
using System.Collections.Generic;

namespace Nintendo.InGameEditing.UI
{
    /// <summary>
    /// ボタンモデルです。
    /// </summary>
    public class ButtonModel : ControlModel
    {
        internal static readonly string UiType = "Button";
        private readonly CommandNode node;

        /// <summary>
        /// ボタンモデルのインスタンスを構築します。
        /// </summary>
        /// <param name="node">元になるノード</param>
        /// <param name="attrs">メタデータに指定された属性の辞書</param>
        internal ButtonModel(CommandNode node, Dictionary<string, string> attrs)
            : base(node, attrs)
        {
            this.node = node;
        }

        /// <summary>
        /// ボタンがクリックされたことをサーバーに通知します。
        /// </summary>
        public void Click() => node.PushCommand(null);
    }
}
