﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// 値の受信時に発行されるイベントの引数です。
    /// </summary>
    public class ValueReceivedEventArgs<T> : EventArgs
    {
        internal ValueReceivedEventArgs(T value)
        {
            Value = value;
        }

        /// <summary>
        /// 受信した値を取得します。
        /// </summary>
        public T Value { get; }
    }
}
