﻿using System;
using System.Reactive.Disposables;

namespace Nintendo.InGameEditing.Utilities
{
    internal static class IDisposableUtility
    {
        internal static void AddTo(this IDisposable disposable, CompositeDisposable disposer)
        {
            if (disposable == null) { throw new ArgumentNullException(nameof(disposable)); }
            if (disposer == null) { throw new ArgumentNullException(nameof(disposer)); }

            disposer.Add(disposable);
        }
    }
}
