﻿using System;
using System.IO;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal class VersionMessage : SystemMessage
    {
        public static MessageType MessageType => MessageType.Version;

        public VersionMessage() : this(Const.CurrentVersion)
        {
        }

        public VersionMessage(Version version)
        {
            Version = version;
        }

        public Version Version { get; }

        internal static VersionMessage Parse(Packet packet)
        {
            using (var stream = new MemoryStream(packet.Payload))
            using (var reader = new BinaryReader(stream))
            {
                var messageType = (MessageType)reader.ReadInt32();
                if (messageType != MessageType) { throw new InvalidDataException(); }

                var version = (Version)reader.ReadUInt32();
                return new VersionMessage(version);
            }
        }
    }
}
