﻿using System;
using System.IO;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal class RemoveNodeMessage : SystemMessage
    {
        public static MessageType MessageType => MessageType.RemoveNode;

        public RemoveNodeMessage(uint id)
        {
            Id = id;
        }

        public uint Id { get; }

        internal static RemoveNodeMessage Parse(Packet packet)
        {
            using (var stream = new MemoryStream(packet.Payload))
            using (var reader = new BinaryReader(stream))
            {
                var messageType = (MessageType)reader.ReadInt32();
                if (messageType != MessageType) { throw new InvalidDataException(); }

                var id = reader.ReadUInt32();
                return new RemoveNodeMessage(id);
            }
        }
    }
}
