﻿using System.IO;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal class MetadataMessage : NodeTargetMessage
    {
        public static MessageType MessageType => MessageType.Metadata;

        public MetadataMessage(uint id, byte[] value) : base(id)
        {
            Value = value ?? Const.EmptyBytes;
        }

        public byte[] Value { get; }

        internal static MetadataMessage Parse(Packet packet)
        {
            using (var stream = new MemoryStream(packet.Payload))
            using (var reader = new BinaryReader(stream))
            {
                var messageType = (MessageType)reader.ReadInt32();
                if (messageType != MessageType) { throw new InvalidDataException(); }

                var id = reader.ReadUInt32();
                var value = reader.ReadBytes((int)(stream.Length - stream.Position));

                return new MetadataMessage(id, value);
            }
        }
    }
}
