﻿using System;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal enum MessageTarget : int
    {
        Invalid = 0,
        System = 0x0100,
        Node = 0x0200,
    }

    internal enum MessageType : int
    {
        Invalid = 0,

        Version     = MessageTarget.System | 0x01,  // ランタイム→ツール or 双方向
        Node        = MessageTarget.System | 0x02,  // ランタイム→ツール
        RemoveNode  = MessageTarget.System | 0x03,  // ランタイム→ツール

        Metadata            = MessageTarget.Node | 0x01,    // ランタイム→ツール
        MetadataRequest     = MessageTarget.Node | 0x02,    // ツール→ランタイム
        Value               = MessageTarget.Node | 0x03,    // 双方向
        ValueRequest        = MessageTarget.Node | 0x04,    // ツール→ランタイム
        UserCommand         = MessageTarget.Node | 0x05,    // 双方向
        ChildNodeRequest    = MessageTarget.Node | 0x06,    // ツール→ランタイム
    }

    internal abstract class Message
    {
        /*
         * 個々の Message 型にパースする場合、
         * static ***Message Parse(Packet)
         * static MessageType MessageType { get; }
         * を定義すること。
         */

        public virtual Packet ToPacket()
        {
            throw new NotSupportedException();
        }
    }

    internal abstract class NodeTargetMessage : Message
    {
        public static bool IsTarget(MessageType type) => type.HasFlag((MessageType)MessageTarget.Node);

        protected NodeTargetMessage(uint id)
        {
            Id = id;
        }

        public uint Id { get; }
    }

    internal abstract class SystemMessage : Message
    {
        public static bool IsTarget(MessageType type) => type.HasFlag((MessageType)MessageTarget.System);
    }
}
