﻿using System;
using System.IO;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal class ChildNodeRequestMessage : NodeTargetMessage
    {
        public static MessageType MessageType => MessageType.ChildNodeRequest;

        public ChildNodeRequestMessage(uint id)
            : base(id)
        {
        }

        public override Packet ToPacket() => MessageHelper.CreatePacket(MessageType, BitConverter.GetBytes(Id));
    }
}
