﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// データ受信時に発行されるイベントの引数です。
    /// </summary>
    public class DataReceivedEventArgs : EventArgs
    {
        internal DataReceivedEventArgs(byte[] data)
        {
            Data = data ?? Const.EmptyBytes;
        }

        /// <summary>
        /// 受信したデータを取得します。
        /// </summary>
        public byte[] Data { get; }
    }
}
