﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// 接続状態が変化した際に発効されるイベントの引数です。
    /// </summary>
    public class ConnectionChangedEventArgs : EventArgs
    {
        internal ConnectionChangedEventArgs(bool isConnected, bool connectable)
        {
            IsConnected = isConnected;
            Connectable = connectable;
        }

        /// <summary>
        /// 接続済みの状態かどうかを取得します。
        /// </summary>
        public bool IsConnected { get; }

        /// <summary>
        /// 接続が可能な状態かどうかを取得します。接続済みの場合でも true を返します。
        /// </summary>
        public bool Connectable { get; }
    }
}
