﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Atk.Binary
{
    internal static class AtkNativeResultExtension
    {
        public static bool IsSucceeded(this AtkNative.Result target)
        {
            return !target.IsFailed();
        }

        public static bool IsFailed(this AtkNative.Result target)
        {
            return ((uint)target & AtkNative.ResultErrorFlag) != 0;
        }
    }
}
