﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_BinaryFormat.h>
#include <nn/atk/atk_WaveFileReader.h>

extern "C" {

static const char nnatktoolWaveEncodingPcm16[] = "PCM16";
static const char nnatktoolWaveEncodingAdpcm[] = "ADPCM";

#pragma pack(push, 8)

struct nnatktoolWaveFormat
{
    char    encoding[16];
    int32_t channelCount;
    int32_t samplerate;
};

struct nnatktoolWaveBinaryInfo
{
    nnatktoolWaveFormat format;

    int64_t sampleCount;

    bool hasLoop;
    uint8_t _padding[7];

    int64_t loopStartFrame;
    int64_t loopEndFrame;
    int64_t originalLoopStartFrame;
    int64_t originalLoopEndFrame;
};

#pragma pack(pop)

}
