﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxutil/Panel.h"
#include "gfxutil/Label.h"
#include "HidPad.h"
#include "SelectItemList.h"
#include "SoundArchivePlayerPanel.h"


class SoundArchiveContext;

//! @brief  SoundParameters のパネルです
class SoundParametersPanel
{
public:
    //! @brief  初期化します
    void Initialize(SoundArchiveContext& soundArchiveContext, float positionX, float positionY, float sizeX, float sizeY) NN_NOEXCEPT;
    //! @brief  更新します
    void Update(const WrappedSoundHandle& handle) NN_NOEXCEPT;
    //! @brief  入力による更新を行います
    void UpdateByHid(WrappedSoundHandle& handle, const HidPad& hidPad) NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(gfxutil::GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  フォーカスを設定します
    void SetFocused(bool isFocused) NN_NOEXCEPT;

private:
    enum ParameterType
    {
        ParameterType_Volume,
        ParameterType_Pitch,
        ParameterType_StartOffset,
        ParameterType_Pan,
        ParameterType_SPan,
        ParameterType_MainSend,
        ParameterType_EffectSendA,
        ParameterType_EffectSendB,
        ParameterType_EffectSendC,
        ParameterType_LpfFrequency,
        ParameterType_BqfType,
        ParameterType_BqfValue,
        ParameterType_MainOutVolume,
        ParameterType_PanMain,
        ParameterType_SPanMain,
        ParameterType_MainSendMain,
        ParameterType_EffectSendAMain,
        ParameterType_EffectSendBMain,
        ParameterType_EffectSendCMain,
        ParameterType_Max,
    };

private:
    static const int SoundHandleCount = SoundArchivePlayerPanel::SoundHandleCount;

private:
    //! @brief  入力によってパラメータを更新します
    void UpdateParametersByHid(WrappedSoundHandle& handle, const HidPad& hidPad) NN_NOEXCEPT;

private:
    gfxutil::Panel m_Panel;
    gfxutil::Label m_ToggleMainOutVolume;
    SelectItemList<ParameterType_Max> m_ItemList;
};
