﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "SoundArchiveContext.h"
#include "gfxutil/Label.h"


//! @brief  情報を表示するパネルです
class InformationPanel
{
public:
    //! @brief  初期化します
    void Initialize(float positionX, float positionY, float sizeX, float sizeY) NN_NOEXCEPT;
    //! @brief  更新します
    void Update(const SoundArchiveContext& soundArchiveContext) NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(gfxutil::GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  SoundMaker と接続されているかを返します
    bool IsConnected() const NN_NOEXCEPT;
    //! @brief  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    //          Reload ラベルを表示しているかを返します
    bool IsDrawReloadLabel() const NN_NOEXCEPT;

    //! @brief  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    //  サウンドアーカイブが再読み込みされたときに呼ばれます
    void OnReloadSoundArchive() NN_NOEXCEPT;

private:
    gfxutil::Label m_Edit;
    bool m_IsConnected;

    //  RELOAD_SOUND_ARCHIVE_TEMP: サウンドアーカイブの再読み込みのための暫定処理
    gfxutil::Label m_ReloadSoundArchive;
    int m_DisplayReloadLabelCount;
};
