﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mem/mem_StandardAllocator.h>
#include <nn/atk.h>
#include "gfxutil/Panel.h"
#include "gfxutil/Label.h"
#include "EffectItem.h"


class HidPad;

//! @brief  Effect のパネルです
class EffectPanel
{
public:
    //! @brief  初期化します
    void Initialize(float positionX, float positionY, float sizeX, float sizeY) NN_NOEXCEPT;
    //! @brief  終了します
    void Finalize(nn::mem::StandardAllocator* pAllocator) NN_NOEXCEPT;
    //! @brief  更新します
    void Update(nn::mem::StandardAllocator* pAllocator) NN_NOEXCEPT;
    //! @brief  入力による更新を行います
    void UpdateByHid(const HidPad& hidPad) NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(gfxutil::GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  フォーカスを設定します
    void SetFocused(bool isFocused) NN_NOEXCEPT;

private:
    //  1 つのバスあたりのエフェクト数
    static const int EffectItemCount = 3;

    gfxutil::Panel m_Panel;
    bool m_IsUpdateParameters;

    //  選択しているバス
    int m_CurrentBusIndex;
    //  バスのうち、何番目のエフェクトを選んでいるか
    int m_CurrentEffectItemIndex;

    //  バスに適用するエフェクト
    EffectItem m_EffectItem[nn::atk::AuxBus_Count][EffectItemCount];

    //  以下、表示用ラベル
    gfxutil::Label m_AuxBusLabel[nn::atk::AuxBus_Count];
    gfxutil::Label m_UsingMemorySizeLabel;
    gfxutil::Label m_CurrentEffectLabel;
};
