﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxutil/GfxContext.h"
#include "gfxutil/Panel.h"
#include "gfxutil/Label.h"
#include "HidPad.h"
#include "SoundArchiveContext.h"
#include "SoundArchivePlayerPanel.h"
#include "SoundParametersPanel.h"
#include "SoundSystemPanel.h"
#include "InformationPanel.h"
#include "EffectPanel.h"
#include "SoundOutputPanel.h"
#include "SpyToolProfiler.h"


//! @brief  アプリケーションとして処理を行います
class Application
{
public:
    //! @brief  初期化します
    void Initialize() NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  更新処理をします
    void Update() NN_NOEXCEPT;
    //! @brief  描画処理をします
    void Draw() NN_NOEXCEPT;

    //! @brief  アプリケーションが続いているかを返します
    bool IsContinue() const NN_NOEXCEPT;

private:
    //! @brief  表示されるパネルの種類
    enum PanelType
    {
        PanelType_SoundArchivePlayer,
        PanelType_SoundParameters,
        PanelType_SoundSystem,
        PanelType_Effect,
        PanelType_SoundOutput,
        PanelType_Max,
    };

private:
    //! @brief  パネルにフォーカスを設定します
    void SetFocusedToPanel() NN_NOEXCEPT;

private:
    gfxutil::GfxContext m_GfxContext;
    SoundArchiveContext m_SoundArchiveContext;
    HidPad              m_HidPad;
    SpyToolProfiler m_SpyToolProfiler;

    SoundArchivePlayerPanel m_SoundArchivePlayerPanel;
    SoundParametersPanel    m_SoundParametersPanel;
    SoundSystemPanel        m_SoundSystemPanel;
    InformationPanel        m_InformationPanel;
    EffectPanel             m_EffectPanel;
    SoundOutputPanel        m_SoundOutputPanel;

    void* m_pMemoryForGfxDevice;
    void* m_pMemoryForSoundSystem;
    void* m_pMemoryForSoundArchive;
    void* m_pMemoryForOpusDecoder;
    void* m_pMemoryForConnection;
    void* m_pMemoryForSoundOutputPanel;
    void* m_pMemoryForSpyModule;

    bool m_IsContinue;
    int  m_FocusPanelType;
    const char* m_StartupSoundArchivePath;

#if !defined( ATKPLAYER_BUILD_CONFIG_ENABLE_GFX )
    int  m_NeedDrawCount;
#endif

    //  nn::atk::SoundSystem の初期化に失敗したとき用の変数
    bool m_IsFailedToInitializeSoundSystem;
    gfxutil::Label m_FailedToInitializeSoundSystemLabel;
};
