﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk.h>
#include "Util.h"
#include "FlightRecorder.h"


//  パラメータを増減させた値を返します
template <> int ChangeParameterValue<int>(int value, int increment, int boost, bool isBoost, bool isIncrement, const char* logTag, const char* logText)
{
    const auto diff = isBoost ? boost : increment;
    const auto result = isIncrement ? value + diff : value - diff;

    FlightRecorder::GetInstance().WriteLog( "[%s] %s : %d -> %d", logTag, logText, value, result );

    return result;
}
template <> float ChangeParameterValue<float>(float value, float increment, float boost, bool isBoost, bool isIncrement, const char* logTag, const char* logText)
{
    const auto diff = isBoost ? boost : increment;
    const auto result = isIncrement ? value + diff : value - diff;

    FlightRecorder::GetInstance().WriteLog( "[%s] %s : %f -> %f", logTag, logText, value, result );

    return result;
}
template <> nn::TimeSpan ChangeParameterValue<nn::TimeSpan>(nn::TimeSpan value, nn::TimeSpan increment, nn::TimeSpan boost, bool isBoost, bool isIncrement, const char* logTag, const char* logText)
{
    const auto diff = isBoost ? boost : increment;
    const auto result = isIncrement ? value + diff : value - diff;

    FlightRecorder::GetInstance().WriteLog( "[%s] %s : %lld -> %lld", logTag, logText, value.GetMilliSeconds(), result.GetMilliSeconds() );

    return result;
}

//  ループする選択を行う
int GetNextValueOnLoopSelection(int next, int loopCount) NN_NOEXCEPT
{
    if( next == -1 )
    {
        return loopCount - 1;
    }
    else if( next == loopCount )
    {
        return 0;
    }
    return next;
}

//  MemoryPool をアタッチします
void AttachMemoryPool(nn::audio::MemoryPoolType* pMemoryPool, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    nn::atk::SoundSystem::AttachMemoryPool( pMemoryPool, buffer, bufferSize );
}
//  MemoryPool をデタッチします
void DetachMemoryPool(nn::audio::MemoryPoolType* pMemoryPool) NN_NOEXCEPT
{
    nn::atk::SoundSystem::DetachMemoryPool( pMemoryPool );
}

const nn::util::Float2 GetFloat2(float x, float y) NN_NOEXCEPT
{
    nn::util::Float2 var;
    var.x = x;
    var.y = y;
    return var;
}
const nn::util::Uint8x4 GetUint8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT
{
    nn::util::Uint8x4 var;
    var.v[0] = x;
    var.v[1] = y;
    var.v[2] = z;
    var.v[3] = w;
    return var;
}
const nn::util::Unorm8x4 GetUnorm8x4(uint8_t x, uint8_t y, uint8_t z, uint8_t w) NN_NOEXCEPT
{
    nn::util::Unorm8x4 var;
    var.v[0] = x;
    var.v[1] = y;
    var.v[2] = z;
    var.v[3] = w;
    return var;
}
