﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

#ifdef NN_GFX_VULKAN
#define UI2D_BINDING_LAYOUT(n) layout( binding = n )
#define UI2D_LOCATION_LAYOUT(n) layout( location = n )
#define UI2D_BINDING(n) binding = n,
#else
#define UI2D_BINDING_LAYOUT(n)
#define UI2D_LOCATION_LAYOUT(n)
#define UI2D_BINDING(n)
#endif

out gl_PerVertex
{
    vec4 gl_Position;
};

layout(UI2D_BINDING(0) std140) uniform uConstantBufferForVertexShader
{
    mat4    uProjection;
    vec4    uModelView[3];
    vec4    uTexMtx0_xz;
    vec4    uTexMtx0_yw;
    vec4    uTexMtx1_xz;
    vec4    uTexMtx1_yw;
    vec4    uTexMtx2_xz;
    vec4    uTexMtx2_yw;
    vec4    uColor;
    mat4    uVertexTexCoord0;
    mat4    uVertexTexCoord1;
    mat4    uVertexTexCoord2;
    vec4    uFrameSize;
    vec2    uPaneSize;
    vec4    uRcpTexSize0;
    mat4    uVertexColorVsh;
    vec4    uTransform;
    ivec3   uGeneratingTexCoord;
    int     uFrameSpec;
};

#if NW_MESH_ENABLED
UI2D_LOCATION_LAYOUT(0) in vec3 aPosition;
UI2D_LOCATION_LAYOUT(1) in vec2 aTexCoord;
#else
UI2D_LOCATION_LAYOUT(0) in vec2 aVertexIndex;

#include "ui2d_VertexShaderCommonHeader.glsl"
#endif

//---------------------------------------------------------------------------
//! @brief ペインの情報からテクスチャ座標を変形します。
//!
//!	@details
//!	ui2d_VertexShaderCommonHeader は aVertexIndex に依存しているため
//!	メッシュ用シェーダーバリエーションではインクルードすることができない。
//!	この関数はメッシュ用シェーダーでも使用したかったため CommonHeader から移設しました。
//!
//! @param[in]
//!
//! @return 変形後の座標です。
//---------------------------------------------------------------------------
vec2 DeformTexCoord(const in vec2 srcTexCoord)
{
    vec2 texCoord = srcTexCoord;

    if ((uFrameSpec & 2) != 0)
    {
        vec4 texScale = uTransform;

        if ((uFrameSpec & 0x10000) != 0)
        {
            texScale.xy = texScale.xy * uRcpTexSize0.yx;
        }
        else
        {
            texScale.xy = texScale.xy * uRcpTexSize0.xy;
        }

        // DOT BY DOT
        if ((uFrameSpec & 16) != 0)
        {
            texCoord.x = texCoord.x * texScale.x;
        }
        if ((uFrameSpec & 32) != 0)
        {
            texCoord.y = texCoord.y * texScale.y;
        }

        // ALIGN
        texScale = 1 - texScale;

        if ((uFrameSpec & 4) != 0)
        {
            texCoord.x = texCoord.x + texScale.x;
        }
        if ((uFrameSpec & 8) != 0)
        {
            texCoord.y = texCoord.y + texScale.y;
        }
    }

    // FLIP / SWAP
    if ((uFrameSpec & 0x20000) != 0)
    {
        texCoord.x = 1 - texCoord.x;
    }
    if ((uFrameSpec & 0x40000) != 0)
    {
        texCoord.y = 1 - texCoord.y;
    }
    if ((uFrameSpec & 0x10000) != 0)
    {
        texCoord.xy = texCoord.yx;
    }

    return texCoord;
}

layout(location = 0) out vec4 vColor;
layout(location = 1) out vec4 vTexCoord[3];
layout(location = 4) out vec4 vLocalPosition;

void main(void)
{
#if	NW_MESH_ENABLED
    vec4 view;
    vec4 position;
    position.xy = aPosition.xy * uTransform.xy;// + sizeAndPosition.zw;
    position.z = aPosition.z;
    position.w = 1.0;
    view.x = dot(position, uModelView[0]);
    view.y = dot(position, uModelView[1]);
    view.z = dot(position, uModelView[2]);
    view.w = 1;
    gl_Position = view * uProjection;
    #ifdef NN_GFX_VULKAN
    gl_Position.y = -gl_Position.y;
    gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
    #endif

    vColor = uColor * vec4(255.0);

    // TEXCOORD TRANSFORM
    #if 0 < NW_MULTI_TEXTURE_QUANTITY
    vec4	texCoord0 = vec4(aTexCoord, 0, 1);
    if (uGeneratingTexCoord.x != 0)
    {
        texCoord0 = position * uVertexTexCoord0;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord0.xy = DeformTexCoord(texCoord0.xy);
    }
    vTexCoord[0].x = dot(vec4(texCoord0.xy, 0.0, 1.0), uTexMtx0_xz);
    vTexCoord[0].y = dot(vec4(texCoord0.xy, 0.0, 1.0), uTexMtx0_yw);
    vTexCoord[0].y = 1 - vTexCoord[0].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[0].w = texCoord0.w;
    #endif
    #if 1 < NW_MULTI_TEXTURE_QUANTITY
    vec4	texCoord1 = vec4(aTexCoord, 0, 1);
    if (uGeneratingTexCoord.y != 0)
    {
        texCoord1 = position * uVertexTexCoord1;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord1.xy = DeformTexCoord(texCoord1.xy);
    }
    vTexCoord[1].x = dot(vec4(texCoord1.xy, 0.0, 1.0), uTexMtx1_xz);
    vTexCoord[1].y = dot(vec4(texCoord1.xy, 0.0, 1.0), uTexMtx1_yw);
    vTexCoord[1].y = 1 - vTexCoord[1].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[1].w = texCoord1.w;
    #endif
    #if 2 < NW_MULTI_TEXTURE_QUANTITY
    vec4	texCoord2 = vec4(aTexCoord, 0, 1);
    if (uGeneratingTexCoord.z != 0)
    {
        texCoord2 = position * uVertexTexCoord2;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord2.xy = DeformTexCoord(texCoord2.xy);
    }
    vTexCoord[2].x = dot(vec4(texCoord2.xy, 0.0, 1.0), uTexMtx2_xz);
    vTexCoord[2].y = dot(vec4(texCoord2.xy, 0.0, 1.0), uTexMtx2_yw);
    vTexCoord[2].y = 1 - vTexCoord[2].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[2].w = texCoord2.w;
    #endif

    // メッシュ表示機能と角丸は同時に使用不可
#else
    //----------------------------------------
    // POSITION TRANSFORM
    vec4 world = ShapeQuad(aVertexIndex, uTransform);
    vec4 view = Transform34(uModelView, world);
    gl_Position = view * uProjection;
    #ifdef NN_GFX_VULKAN
    gl_Position.y = -gl_Position.y;
    gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
    #endif

    //----------------------------------------
    // TEXCOORD & COLOR

    vec4 color;
    #if NW_MULTI_TEXTURE_QUANTITY == 0
    ComputeColorAndTexCoord(color);
    #elif NW_MULTI_TEXTURE_QUANTITY == 1
    vec4 texCoord0;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0);
    #elif NW_MULTI_TEXTURE_QUANTITY == 2
    vec4 texCoord0;
    vec4 texCoord1;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0, uVertexTexCoord1, texCoord1);
    #elif NW_MULTI_TEXTURE_QUANTITY == 3
    vec4 texCoord0;
    vec4 texCoord1;
    vec4 texCoord2;
    ComputeColorAndTexCoord(color, uVertexTexCoord0, texCoord0, uVertexTexCoord1, texCoord1, uVertexTexCoord2, texCoord2);
    #endif

    // TEXCOORD TRANSFORM
    #if 0 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.x != 0)
    {
        texCoord0 = world * uVertexTexCoord0;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord0.xy = DeformTexCoord(texCoord0.xy);
    }
    vTexCoord[0].x = dot(vec4(texCoord0.xy, 0.0, 1.0), uTexMtx0_xz);
    vTexCoord[0].y = dot(vec4(texCoord0.xy, 0.0, 1.0), uTexMtx0_yw);
    vTexCoord[0].y = 1 - vTexCoord[0].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[0].w = texCoord0.w;
    #endif
    #if 1 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.y != 0)
    {
        texCoord1 = world * uVertexTexCoord1;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord1.xy = DeformTexCoord(texCoord1.xy);
    }
    vTexCoord[1].x = dot(vec4(texCoord1.xy, 0.0, 1.0), uTexMtx1_xz);
    vTexCoord[1].y = dot(vec4(texCoord1.xy, 0.0, 1.0), uTexMtx1_yw);
    vTexCoord[1].y = 1 - vTexCoord[1].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[1].w = texCoord1.w;
    #endif
    #if 2 < NW_MULTI_TEXTURE_QUANTITY
    if (uGeneratingTexCoord.z != 0)
    {
        texCoord2 = world * uVertexTexCoord2;
    }
    else if ((uFrameSpec & 1) != 0)
    {
        texCoord2.xy = DeformTexCoord(texCoord2.xy);
    }
    vTexCoord[2].x = dot(vec4(texCoord2.xy, 0.0, 1.0), uTexMtx2_xz);
    vTexCoord[2].y = dot(vec4(texCoord2.xy, 0.0, 1.0), uTexMtx2_yw);
    vTexCoord[2].y = 1 - vTexCoord[2].y; // ADJUST GL vs. GX2 TEXTURE UV ORIGIN HERE
    vTexCoord[2].w = texCoord2.w;
    #endif

#if NW_PROCEDURAL_SHAPE > 0
    vLocalPosition.xy = aVertexIndex.xy;
    vLocalPosition.z = 0.0;
    vLocalPosition.w = 1.0;
#endif

    // GLOBAL COLOR
#if NW_VERTEX_COLOR_ENABLED
    vColor = color * uColor;
#endif
#endif
}

