﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

#ifdef NN_GFX_VULKAN
#define UI2D_BINDING_LAYOUT(n) layout( binding = n )
#define UI2D_LOCATION_LAYOUT(n) layout( location = n )
#define UI2D_BINDING(n) binding = n,
#else
#define UI2D_BINDING_LAYOUT(n)
#define UI2D_LOCATION_LAYOUT(n)
#define UI2D_BINDING(n)
#endif

UI2D_BINDING_LAYOUT(1) uniform sampler2D uTexture0;
UI2D_BINDING_LAYOUT(2) uniform sampler2D uTexture1;
UI2D_BINDING_LAYOUT(3) uniform sampler2D uTexture2;

layout(location = 0) out vec4 o_Color;

#if NW_DETAILED_COMBINER_ENABLED == 0 && NW_COMBINERUSERSHADER_TYPE == 0
// 標準モード利用時用コンスタントバッファ
layout(UI2D_BINDING(4) std140) uniform uConstantBufferForPixelShader
{
    vec4 uInterpolateWidth;
    vec4 uInterpolateOffset;
    vec4 uIndirectMtx0;
    vec4 uIndirectMtx1;
    mat4 uVertexColorPsh;    // 現在利用されていないパディング領域です。
    int uTextureMode;
    int uColorEffectMode;    // 現在利用されていないパディング領域です。
    vec2 uPadding0;
};
#elif NW_DETAILED_COMBINER_ENABLED == 1
// 詳細コンバイナ利用時用のコンスタントバッファ
layout(UI2D_BINDING(4) std140) uniform uConstantBufferForPixelShader
{
    int uCombinerStageCountMax;
    float uPadding1_0;
    int uPadding1_1;
    int uPadding1_2;
    vec4 uCombinerConstantColor[7];
    ivec4 uCombinerStageBit[6];
};
#else
// コンバイナユーザーシェーダ利用時用コンスタントバッファ
layout(UI2D_BINDING(4) std140) uniform uConstantBufferForPixelShader
{
    float fixedZero;
    float paneWidth;
    float paneHeight;
    int uPadding_0;
    vec4 uConstantColor[7];

    vec4 modelViewM[3];
    vec4 modelM[3];
    vec4 viewM[3];
    vec3 cameraPosition;
    int uPadding_3;

    int   userData_i0, userData_i1, userData_i2, userData_i3;
    ivec2 userData_ivec2[4];
    ivec4 userData_rgba[4];
    float userData_f0, userData_f1, userData_f2, userData_f3;
    vec2  userData_vec2[4];
    vec3  userData_vec3[4];

    vec2  uTextureSize[3];				// 配列のアクセス時 128bit アライメントなので、実質 vec4
};
#endif

#if NW_TEXTURE_COMBINE_TYPE == 130
// ドロップシャドウブラー用コンスタントバッファ
layout(UI2D_BINDING(6) std140) uniform uDropShadowBlur
{
    vec4 uDropShadowColor;
    // x: スプレッド y: 中心ピクセルのウエイト z: ペイン透明度 w: ペイン透明度の逆数
    vec4 uSpreadAndCenterWeightAndPaneTransparency;
    vec4 uOffsetsH[4];
    vec4 uOffsetsV[4];
    vec4 uWeights[4];
};
#endif

#if NW_PROCEDURAL_SHAPE > 0
// 任意形状用コンスタントバッファ
layout(UI2D_BINDING(7) std140) uniform uProceduralShape
{
    vec4 uProceduralShapeSizeParams;
    vec4 uProceduralShapeParams;
    ivec4 uBlendType;
    vec4 uInnerStrokeParams;
    vec4 uInnerStrokeColor;
    vec4 uInnerShadowParams;
    vec4 uInnerShadowColor;
    vec4 uInnerShadowAttenuation;
    vec4 uColorOverlayColor;
    vec4 uGradationOverlayControlPoints;
    vec4 uGradationOverlayColors[4];
    vec4 uGradationOverlayAngleParams;
};
#endif

// 詳細コンバイナ用 バリエーション定数設定
layout(UI2D_BINDING(5) std140) uniform VariationConstant
{
    uint stageCount;
    ivec4 bit0;
    ivec4 bit1;
    ivec4 bit2;
    ivec4 bit3;
    ivec4 bit4;
    ivec4 bit5;
};

layout(location = 0) in vec4 vColor;
layout(location = 1) in vec4 vTexCoord[3];
layout(location = 4) in vec4 vLocalPosition;

#if NW_DETAILED_COMBINER_ENABLED == 0 && NW_COMBINERUSERSHADER_TYPE == 0
// 標準用ヘッダ
#include "ui2d_PixelShaderCommonHeader.glsl"
#elif NW_DETAILED_COMBINER_ENABLED == 1
// 詳細コンバイナ用ヘッダ
#include "ui2d_PixelShaderCombinerHeader.glsl"
#else
// コンバイナユーザーシェーダー用ヘッダ
#include "ui2d_PixelShaderCombinerUserShaderHeader.glsl"
#include "CombinerUserShaderVariation.glsl"
#endif

#if NW_PROCEDURAL_SHAPE > 0
float CalculateDistance(in vec2 pos, in float functionExp, in vec2 cornerOffset, out float isInCorner, in float scale)
{
    vec2 one = vec2(1.0, 1.0);
    vec2 absPos = abs(pos);

    // 符号付の角丸オフセット位置を計算
    vec2 cornerCenterWithSign = sign(pos) * cornerOffset;
    // 角丸原点からの符号付オフセット値(変換前座標系)
    vec2 cornerOriginOffset = pos - cornerCenterWithSign;
    // 角丸のサイズ(変換前座標系)
    vec2 cornerSize = one - cornerOffset;

    // 角丸サイズ単位の角丸原点からの距離を計算する
    vec2  distanceFromCornerOriginAbs = abs(cornerOriginOffset / cornerSize) * (1.0 / scale);

    // 角丸原点で関数を評価
    vec2 expValue = vec2(functionExp, functionExp);
    vec2 functionValue = pow(distanceFromCornerOriginAbs, expValue);

    // 角丸原点からの距離が正の場合にエッジ領域と判断する
    vec2 inEdge = clamp(sign(cornerOffset - absPos), 0.0, 1.0);

    float centerBox = inEdge.x * inEdge.y;
    float inCorner = (1.0 - inEdge.x) * (1.0 - inEdge.y);
    isInCorner = inCorner;
    // 角丸領域の場合は (x + y)
    float distance = (functionValue.x + functionValue.y) * inCorner;
    // 左右左右のエッジの場合は角丸との境界の値をリピートする
    distance += inEdge.x * functionValue.y;
    distance += inEdge.y * functionValue.x;
    // 中心の領域は角丸サイズで分割された負の値がリピートする
    distance *= (1.0 - centerBox);
    distance -= (distanceFromCornerOriginAbs.x * distanceFromCornerOriginAbs.y * centerBox);

    return distance;
}

//-------------------------------------------------------------------
// 角丸機能用ブレンド実装
//-------------------------------------------------------------------
vec4 ProceduralShapeBlend(in int type, in vec4 color1, in vec4 color2)
{
    vec4    color;
    vec4    white = vec4(1.0, 1.0, 1.0, 1.0);

    if (type == 1)
    {
        //  DropShadowBlendMode_Mul,
        color.rgb = (color1.rgb * (color2.rgb + (white.rgb - color2.rgb) * (1.0 - color2.a)));
        color.a = color1.a;
    }
    else if (type == 2)
    {
        //  DropShadowBlendMode_Add,
        color.rgb = color1.rgb + (color2.rgb * color2.a);
        color.a = color1.a;
    }
    else if (type == 3)
    {
        //  DropShadowBlendMode_Sub,
        color.rgb = color1.rgb - (color2.rgb * color2.a);
        color.a = color1.a;
    }
    else
    {
        //  DropShadowBlendMode_Normal,
        color.rgb = ((color1.rgb * (1.0 - color2.a)) + (color2.rgb * color2.a));
        color.a = color1.a;
    }

    return color;
}

#endif

#if NW_COMBINERUSERSHADER_TYPE == 0
void main(void)
{
#if !NW_DETAILED_COMBINER_ENABLED

#if 0 < NW_MULTI_TEXTURE_QUANTITY
    vec2 vUv0 = vTexCoord[0].xy;
#endif
#if 1 < NW_MULTI_TEXTURE_QUANTITY
    vec2 vUv1 = vTexCoord[1].xy;
#endif
#if 2 < NW_MULTI_TEXTURE_QUANTITY
    vec2 vUv2 = vTexCoord[2].xy;
#endif

#if NW_TEXTURE_PROJECTION_IN_PIXEL_SHADER
#if 0 < NW_MULTI_TEXTURE_QUANTITY
    vUv0.xy /= vTexCoord[0].w;
#endif
#if 1 < NW_MULTI_TEXTURE_QUANTITY
    vUv1.xy /= vTexCoord[1].w;
#endif
#if 2 < NW_MULTI_TEXTURE_QUANTITY
    vUv2.xy /= vTexCoord[2].w;
#endif
#endif

    //----------------------------------------
    // COMBINE TEXTURE COLOR

    // デフォルトシェーダーで、NW_TEXTURE_COMBINE_TYPE の値が 100 以上に各種専用シェーダーを割り当てる
    // 120 -> マスク用シェーダー
#if NW_TEXTURE_COMBINE_TYPE < 100
#if NW_MULTI_TEXTURE_QUANTITY == 3
    // 3枚ブレンド
    vec4 textureColor;

    // 11, 12, 13 がインダイレクト 用に割り当てられている。
    #if NW_TEXTURE_COMBINE_TYPE == 11
        vec4 textureColor1 = texture(uTexture1, vUv1.st);
        // INDIRECT TEXTURE = uTexture1
        textureColor = SampleColorWithSingleIndirectTexture(
            textureColor1, uTexture0, vUv0);
        bool selectAlphaMax2 = (uTextureMode & SELECT_ALPHA_MAX_MASK2) == 0;
        CombineColor2(texture(uTexture2, vUv2), selectAlphaMax2, textureColor);
    #elif NW_TEXTURE_COMBINE_TYPE == 12 || NW_TEXTURE_COMBINE_TYPE == 13
        // EACH_INDIRECT(13) は本来無効な指定だが、過去バージョンと同じ挙動となるように、処理を合わせている。
        vec4 textureColor1 = texture(uTexture1, vUv1);
        // INDIRECT TEXTURE = (uTexture1 & uTexture2)
        textureColor = SampleColorWithDoubleIndirectTexture(
            textureColor1, texture(uTexture2, vUv2), uTexture0, vUv0);
    #elif NW_TEXTURE_COMBINE_TYPE2 == 13
        bool selectAlphaMax1 = (uTextureMode & SELECT_ALPHA_MAX_MASK1) == 0;
        vec4 indirect = texture(uTexture2, vUv2);
        // INDIRECT TEXTURE = uTexture2
        textureColor = SampleColorWithSingleIndirectTexture(
            indirect, uTexture0, vUv0);
        // INDIRECT TEXTURE = uTexture2
        vec4 textureColor1 = SampleColorWithSingleIndirectTexture(
            indirect, uTexture1, vUv1);
        CombineColor(textureColor1, selectAlphaMax1, textureColor);
    #elif NW_TEXTURE_COMBINE_TYPE2 == 11 || NW_TEXTURE_COMBINE_TYPE2 == 12
        // BLEND_INDIRECT(12) は本来無効な指定だが、過去バージョンと同じ挙動となるように、処理を合わせている。
        int colorMode1 = uTextureMode & COMBINE_MODE_MASK;
        bool selectAlphaMax1 = (uTextureMode & SELECT_ALPHA_MAX_MASK1) == 0;
        // INDIRECT TEXTURE = uTexture2
        vec4 textureColor1 = SampleColorWithSingleIndirectTexture(
            texture(uTexture2, vUv2), uTexture1, vUv1);
        textureColor = texture(uTexture0, vUv0);
        CombineColor(textureColor1, selectAlphaMax1, textureColor);
    #else
        textureColor = texture(uTexture0, vUv0);
        bool selectAlphaMax1 = (uTextureMode & SELECT_ALPHA_MAX_MASK1) == 0;
        CombineColor(texture(uTexture1, vUv1), selectAlphaMax1, textureColor);
        bool selectAlphaMax2 = (uTextureMode & SELECT_ALPHA_MAX_MASK2) == 0;
        CombineColor2(texture(uTexture2, vUv2), selectAlphaMax2, textureColor);
    #endif
#else
    // 0,1,2 枚ブレンド
    #if NW_INDIRECT_TEXTURE_ENABLED
        vec4 textureColor1 = texture(uTexture1, vUv1);
        vec4 textureColor = SampleColorWithSingleIndirectTexture(textureColor1, uTexture0, vUv0);
    #else
        #if 0 < NW_MULTI_TEXTURE_QUANTITY
        vec4 textureColor = texture(uTexture0, vUv0);
        #endif
        #if 1 < NW_MULTI_TEXTURE_QUANTITY
        bool selectAlphaMax1 = (uTextureMode & SELECT_ALPHA_MAX_MASK1) == 0;
        CombineColor(texture(uTexture1, vUv1), selectAlphaMax1, textureColor);
        #endif
    #endif

#endif

    //----------------------------------------
    // COMPUTE PIXEL COLOR
#if 0 < NW_MULTI_TEXTURE_QUANTITY
    vec4 color = uInterpolateOffset + uInterpolateWidth * textureColor;
#else
    vec4 color = uInterpolateWidth;
#endif

#if NW_VERTEX_COLOR_ENABLED
    color *= vColor;

#endif

    //----------------------------------------------------------------------------
    // 特定の機能用専用シェーダー
#else // NW_TEXTURE_COMBINE_TYPE < 100
    //----------------------------------------------------------------------------
    // マスク用シェーダー
    //----------------------------------------------------------------------------
    #if NW_TEXTURE_COMBINE_TYPE == 120
        vec4 color = texture(uTexture0, vUv0);
        color.a *= texture(uTexture1, vUv1).a;
    #endif
    //----------------------------------------------------------------------------
    // ドロップシャドウ関連シェーダー
    //----------------------------------------------------------------------------
    #if NW_TEXTURE_COMBINE_TYPE == 130
        #if (NW_TEXTURE_COMBINE_TYPE2 % 10) < 4
            // 横ブラーシェーダー
            // NW_TEXTURE_COMBINE_TYPE2 が 0 - 3 でループ回数(n + 1)に対応したバリエーションが実装されている
            // uOffsets には 隣り合う 2 ピクセルのウエイトを考慮したサンプリングオフセットが入っており、一回のフェッチで 2 ピクセル分のブレンド処理を行っている
            vec4 color = vec4(0.0, 0.0, 0.0, 1.0);

            color.r = uSpreadAndCenterWeightAndPaneTransparency.y * texture2D(uTexture0, vUv0.st).a;

            for (int i = 0; i < ((NW_TEXTURE_COMBINE_TYPE2 % 10) + 1); ++i)
            {
                vec2    samplingOffset = vec2(uOffsetsH[i].x, 0.0);
                color.r += uWeights[i].x * texture2D(uTexture0, vUv0.st - samplingOffset).a;
                color.r += uWeights[i].x * texture2D(uTexture0, vUv0.st + samplingOffset).a;
                samplingOffset = vec2(uOffsetsH[i].y, 0.0);
                color.r += uWeights[i].y * texture2D(uTexture0, vUv0.st - samplingOffset).a;
                color.r += uWeights[i].y * texture2D(uTexture0, vUv0.st + samplingOffset).a;
                samplingOffset = vec2(uOffsetsH[i].z, 0.0);
                color.r += uWeights[i].z * texture2D(uTexture0, vUv0.st - samplingOffset).a;
                color.r += uWeights[i].z * texture2D(uTexture0, vUv0.st + samplingOffset).a;
                samplingOffset = vec2(uOffsetsH[i].w, 0.0);
                color.r += uWeights[i].w * texture2D(uTexture0, vUv0.st - samplingOffset).a;
                color.r += uWeights[i].w * texture2D(uTexture0, vUv0.st + samplingOffset).a;
            }
        #elif (NW_TEXTURE_COMBINE_TYPE2 % 10) < 8
            // NW_TEXTURE_COMBINE_TYPE2 が 4 - 7 でループ回数(n - 4 + 1)に対応したバリエーションが実装されている
            // uOffsets には 隣り合う 2 ピクセルのウエイトを考慮したサンプリングオフセットが入っており、一回のフェッチで 2 ピクセル分のブレンド処理を行っている
            vec4 color = uDropShadowColor;

            color.a = uSpreadAndCenterWeightAndPaneTransparency.y * texture2D(uTexture0, vUv0.st).r;

            for (int i = 0; i < (((NW_TEXTURE_COMBINE_TYPE2 % 10) - 4) + 1); ++i)
            {
                vec2    samplingOffset = vec2(0.0, uOffsetsV[i].x);
                color.a += uWeights[i].x * texture2D(uTexture0, vUv0.st - samplingOffset).r;
                color.a += uWeights[i].x * texture2D(uTexture0, vUv0.st + samplingOffset).r;
                samplingOffset = vec2(0.0, uOffsetsV[i].y);
                color.a += uWeights[i].y * texture2D(uTexture0, vUv0.st - samplingOffset).r;
                color.a += uWeights[i].y * texture2D(uTexture0, vUv0.st + samplingOffset).r;
                samplingOffset = vec2(0.0, uOffsetsV[i].z);
                color.a += uWeights[i].z * texture2D(uTexture0, vUv0.st - samplingOffset).r;
                color.a += uWeights[i].z * texture2D(uTexture0, vUv0.st + samplingOffset).r;
                samplingOffset = vec2(0.0, uOffsetsV[i].w);
                color.a += uWeights[i].w * texture2D(uTexture0, vUv0.st - samplingOffset).r;
                color.a += uWeights[i].w * texture2D(uTexture0, vUv0.st + samplingOffset).r;
            }

            // ペインの透明度の逆数をかけて元画像のアルファ値を復元する。
            color.a *= uSpreadAndCenterWeightAndPaneTransparency.w;

            // スプレッド処理
            color.a *= uSpreadAndCenterWeightAndPaneTransparency.x;
            // この後に続くノックアウトと乗算ブレンドではアルファが 0.0 - 1.0 の範囲に収まっている必要があるためクランプする。
            color.a = clamp(color.a, 0.0, 1.0);

            // ペインの透明度の影響を加える。
            color.a *= (uSpreadAndCenterWeightAndPaneTransparency.z * uDropShadowColor.a);
        #elif (NW_TEXTURE_COMBINE_TYPE2 % 10) == 8
            // ペイン本体描画用のコピーシェーダー
            vec4 color = texture(uTexture0, vUv0);
            color.a *= vColor.a;
        #endif

        #if (NW_TEXTURE_COMBINE_TYPE2 / 100) == 1
            // ノックアウト用シェーダー
            // uSpreadAndCenterWeightAndPaneTransparency.w にはペインの透明度の逆数が入っている
            color.a *= (1.0 - (texture2D(uTexture1, vUv1.st).a * uSpreadAndCenterWeightAndPaneTransparency.w));
        #endif

        #if ((NW_TEXTURE_COMBINE_TYPE2 / 10) % 10) == 1
            // 乗算ブレンド用シェーダー
            // αを考慮した乗算ブレンドのためにカラーを補正する。
            // カラーが乗算されるため、アルファが 0 に近いほど白に近づける。
            vec4 diff = vec4(1.0, 1.0, 1.0, 1.0);
            diff -= color;
            diff.rgb *= (1.0 - color.a);

            color.rgb += diff.rgb;
        #endif
    #endif
#endif // NW_TEXTURE_COMBINE_TYPE < 100

#else
#if NW_TEXTURE_COMBINE_TYPE == 110
    // バリエーション変数を利用した詳細コンバイナコード。 uCombinerConstantColor 以外の変数は利用されなくなります。
    vec4 color = SampleColorWithVariationVariableDetailedCombiner(
       uCombinerConstantColor,
       uTexture0,
       uTexture1,
       uTexture2,
       vTexCoord,
       #if NW_VERTEX_COLOR_ENABLED
       vColor
       #else
       vec4(1.0f)
       #endif
    );

    // 最適化により uTexture がシンボル除去されるのを防止します。 uPadding1_0 は常に '0.0f' がランタイムより渡されます。
    if (uPadding1_0 != 0.0f)
    {
        // 最適化防止の為、このコードが行われる事はありません。
        float colorAlpha =
            texture(uTexture0, vTexCoord[0].st).a +
            texture(uTexture1, vTexCoord[1].st).a +
            texture(uTexture2, vTexCoord[2].st).a;
        color.a += colorAlpha * uPadding1_0;
    }
#else
    // 動的な詳細コンバイナコード、コンスタントバッファの値により分岐を行います。
    vec4 color = SampleColorWithDetailedCombiner(
       uCombinerStageCountMax,
       uCombinerStageBit,
       uCombinerConstantColor,
       uTexture0,
       uTexture1,
       uTexture2,
       vTexCoord,
       #if NW_VERTEX_COLOR_ENABLED
       vColor
       #else
       vec4(1.0f)
       #endif
    );
#endif

#endif // NW_DETAILED_COMBINER_ENABLED

#if NW_PROCEDURAL_SHAPE > 0
    vec2    shapeEvaluatePos, shapeEvaluatePosAbs;
    shapeEvaluatePos.x = (vLocalPosition.x - 0.5) * 2.0;
    shapeEvaluatePos.y = (vLocalPosition.y - 0.5) * 2.0;
    shapeEvaluatePosAbs = abs(shapeEvaluatePos);

    vec2 paneSize = vec2(uProceduralShapeSizeParams.x, uProceduralShapeSizeParams.y);
    vec2 cornerOffset = vec2(uProceduralShapeParams.y, uProceduralShapeParams.z);

    float functionExp = uProceduralShapeParams.x;
    float cornerSize = uProceduralShapeSizeParams.z;
    float isInCorner;

    // 形状
    float distance = CalculateDistance(shapeEvaluatePosAbs, functionExp, cornerOffset, isInCorner, 1.0);
    // エッジのアルファぼかし
    // functionExp < 1.0 の時のみ角丸部分だけアンチエイリアスを強くかけるためのスケールを計算
    float cornerEdgeAlphaScale = 1.0 + ((isInCorner * 4.0)) * clamp(-(functionExp - 1.0) * 2.0, 0.0, 1.0);
    // cornerSize ピクセルが 0.0 - 1.0 にマップされるので 0.5 ピクセル分に当たるサイズを設定する
    float edgeAntiAliasRange = 1.0 / cornerSize * 0.5 * functionExp * cornerEdgeAlphaScale;
    // また、角丸サイズが 0 で角丸が発生しない場合はエッジのアルファぼかしを行わない
    float enableCorner = step(0.01, cornerSize);
    float edgeAlpha = 1.0 - clamp(clamp(distance - (1.0 - edgeAntiAliasRange), 0.0, 1.0) / edgeAntiAliasRange, 0.0, 1.0);
    edgeAlpha += (1.0 - enableCorner);
    color.a *= (sign(1.0 - distance) * edgeAlpha);

    // グラデーションオーバーレイ
    if (uGradationOverlayControlPoints.x >= 0.0)
    {
        // 回転させて 0.0 - 1.0 へマップする
        float gradationEvaluateValue = cos(uGradationOverlayAngleParams.x) * shapeEvaluatePos.x + sin(uGradationOverlayAngleParams.x) * shapeEvaluatePos.y;
        gradationEvaluateValue = gradationEvaluateValue * 0.5 + 0.5;

        float minValue = step(0.0, uGradationOverlayControlPoints.x - gradationEvaluateValue);
        float maxValue = step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints.w);
        // 各区間の開始地点からのオフセットを計算する
        vec4 interpolateRange = uGradationOverlayControlPoints.yzww - uGradationOverlayControlPoints.xyzw + 0.00001;
        // 各区間が有効かどうかの係数を作成する
        vec4 inRange;
        inRange.x = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[0]) * step(0.0, uGradationOverlayControlPoints[1] - gradationEvaluateValue));
        inRange.y = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[1]) * step(0.0, uGradationOverlayControlPoints[2] - gradationEvaluateValue));
        inRange.z = (step(0.0, gradationEvaluateValue - uGradationOverlayControlPoints[2]) * step(0.0, uGradationOverlayControlPoints[3] - gradationEvaluateValue));
        // 各区間ごとに補間する
        vec4 color0 = mix(uGradationOverlayColors[0], uGradationOverlayColors[1], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[0]) / interpolateRange.x, 0.0, 1.0)) * inRange.x;
        vec4 color1 = mix(uGradationOverlayColors[1], uGradationOverlayColors[2], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[1]) / interpolateRange.y, 0.0, 1.0)) * inRange.y;
        vec4 color2 = mix(uGradationOverlayColors[2], uGradationOverlayColors[3], clamp((gradationEvaluateValue - uGradationOverlayControlPoints[2]) / interpolateRange.z, 0.0, 1.0)) * inRange.z;

        vec4 interpolatedColor = uGradationOverlayColors[0] * minValue + color0 + color1 + color2 + uGradationOverlayColors[3] * maxValue;

        color = ProceduralShapeBlend(uBlendType.w, color, interpolatedColor);
    }

    // カラーオーバーレイ
    if (uColorOverlayColor.a > 0.0)
    {
        color = ProceduralShapeBlend(uBlendType.z, color, uColorOverlayColor);
    }

    // シャドウ(内側)
    if (uInnerShadowColor.a > 0.0)
    {
        float   innerShadowSize = uInnerShadowParams.x;
        float   innerShadowOffsetX = uInnerShadowParams.y;
        float   innerShadowOffsetY = uInnerShadowParams.z;
        float   innerShadowCornerRatio = uProceduralShapeParams.w;

        vec2	shadowEvaluatePos = shapeEvaluatePos;
        shadowEvaluatePos.x += innerShadowOffsetX;
        shadowEvaluatePos.y += innerShadowOffsetY;

        float innerShadowDistance = CalculateDistance(shadowEvaluatePos, functionExp, cornerOffset, isInCorner, 1.0);
        float innerShadowValue = clamp((innerShadowDistance - (1.0 - innerShadowSize)) / innerShadowSize, 0.0, 1.0);

        vec4    attenuation;
        attenuation.x = clamp(pow(innerShadowValue, 2.0), 0.0, 1.0);
        attenuation.y = clamp(pow(innerShadowValue, 1.0), 0.0, 1.0);
        attenuation.z = clamp(1.0 - pow(1.0 - innerShadowValue, 2.0), 0.0, 1.0);
        attenuation.w = 0.0;

        vec4 innerShadowBlendColor;
        innerShadowBlendColor = ProceduralShapeBlend(uBlendType.y, color, uInnerShadowColor) - color;
        color += innerShadowBlendColor * dot(uInnerShadowAttenuation, attenuation);
    }

    // 境界線(内側)
    if (uInnerStrokeColor.a > 0.0)
    {
        // 角丸サイズ基準
        float innerStrokeSize = uInnerStrokeParams.x;

        // 角丸以外のエッジ部分の境界線の作成
        vec2 strokeEdgeLocalSize = vec2(innerStrokeSize / (paneSize.x * 0.5), innerStrokeSize / (paneSize.y * 0.5));
        float strokeEdgeVertical = (shapeEvaluatePosAbs.x - (1.0 - strokeEdgeLocalSize.x)) / strokeEdgeLocalSize.x;
        float strokeEdgeHorizontal = (shapeEvaluatePosAbs.y - (1.0 - strokeEdgeLocalSize.y)) / strokeEdgeLocalSize.y;
        float edgeStrokeValue = clamp(sign(strokeEdgeVertical), 0.0, 1.0) + clamp(sign(strokeEdgeHorizontal), 0.0, 1.0);

        // 形状が 1.0 の時は角丸の中心位置を内側にずらして境界線の幅を均等にする(ずらす量は x, y それぞれ cos 45)。
        // 形状が 2.0 の時は角の大きさを変えて同心円状にするため、 1.0 - 2.0 で線形補間して影響をコントロールする。
        float interpolateValue = clamp(2.0 - functionExp, 0.0, 1.0) * 0.707;
        // 境界線用の角丸のスケール
        // 1.0 より大きい場合は角丸のスケールを形状に応じて線形補間して同心円状に境界線が作成されるようにする。
        float radiusScale = 1.0 - ((innerStrokeSize / cornerSize) * clamp(functionExp - 1.0, 0.0, 1.0)) * step(1.0, functionExp);

        // 角丸の距離評価のための中心位置をずらす。
        vec2 centerOffset = strokeEdgeLocalSize * interpolateValue;
        vec2 innerStrokeEvaluatePos = shapeEvaluatePosAbs + centerOffset;

        float innerStrokeDistance = CalculateDistance(innerStrokeEvaluatePos, functionExp, cornerOffset, isInCorner, radiusScale);
        // 0 よりも大きい部分はすべて塗りつぶす。
        // エッジのアンチエイリアスによって不要な部分はアルファが 0 になるため問題ない。
        float cornerStrokeValue = clamp(sign(innerStrokeDistance), 0.0, 1.0) * isInCorner;

        // 内部エッジのアンチエイリアス
        float edgeAntiAliasPixel = 1.0;
        vec2 edgeAntiAlias = vec2(edgeAntiAliasPixel / (paneSize.x * 0.5), edgeAntiAliasPixel / (paneSize.y * 0.5));
        float edgeStrokeAlphaHorizontal = clamp(strokeEdgeHorizontal / edgeAntiAlias.x, 0.0, 1.0) + clamp(-sign(strokeEdgeHorizontal), 0.0, 1.0);
        float edgeStrokeAlphaVertical = clamp(strokeEdgeVertical / edgeAntiAlias.y, 0.0, 1.0) + clamp(-sign(strokeEdgeVertical), 0.0, 1.0);

        // 辺のアンチエイリアス領域以降が透明にならないように、アンチエイリアスの端部分から 1.0 を加算する。
        edgeStrokeAlphaVertical += step(1.0, strokeEdgeHorizontal / edgeAntiAlias.x);
        edgeStrokeAlphaHorizontal += step(1.0, strokeEdgeVertical / edgeAntiAlias.y);

        float innerEdgeAlpha = clamp(edgeStrokeAlphaHorizontal * edgeStrokeAlphaVertical, 0.0, 1.0);

        // 角丸内側の境界線エッジのアンチエイリアス
        float cornerSizeRatio = cornerSize / 500.0;
        // 角丸単位のぼかし幅レンジ
        float cornerAntiAliasRange = 0.002 + (1.0 - cornerSizeRatio) * (1.0 / cornerSize);
        float cornerAntiAliasRangeHalf = cornerAntiAliasRange * 0.5;
        float cornerAlphaMask = clamp(((innerStrokeDistance - (1.0 - cornerAntiAliasRangeHalf)) + cornerAntiAliasRangeHalf) / cornerAntiAliasRange, 0.0, 1.0);
        float cornerAlpha = cornerAlphaMask * isInCorner + (1.0 - isInCorner);

        // エッジのアルファと角丸のアルファを統合すると必要ないところが透明になったりするため、アルファ値を調整する
        cornerAlpha += edgeStrokeValue;
        float alpha = clamp(innerEdgeAlpha * cornerAlpha + step(1.0, cornerAlphaMask), 0.0, 1.0);

        vec4 innerStrokeColor = uInnerStrokeColor;

        innerStrokeColor.a *= alpha;

        float innerStroke = clamp(edgeStrokeValue + cornerStrokeValue, 0.0, 1.0);
        vec4  innerStrokeBlendColor;

        innerStrokeBlendColor = ProceduralShapeBlend(uBlendType.x, color, innerStrokeColor) - color;
        color += innerStrokeBlendColor * innerStroke;
    }
#endif

    // 浮動小数点数バッファにおいてもブレンド処理を正しく行うためアルファを 0.0 - 1.0 にクランプする。
    color.a = clamp(color.a, 0.0f, 1.0);
    o_Color = color;
}
#endif
