﻿/*---------------------------------------------------------------------------*
  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

layout(std140) uniform Projection
{
    mat4 wvp;
};

layout(std140) uniform Model
{
    uniform mat4 user;
    uniform vec4 color0;
    uniform vec4 color1;
    uniform vec2 uv_src;
    uniform vec2 uv_size;
    float rate;
};

in vec3 i_Vertex;
in vec2 i_TexCoord;
in vec4 i_ColorRate;

out gl_PerVertex {
  vec4 gl_Position;
};
layout(location = 0) out vec4 color;
layout(location = 1) out vec4 texCoord;

void main(void)
{
    gl_Position = vec4( i_Vertex, 1 ) * user * wvp;
    color = color0 * ( 1.0 - i_ColorRate.r ) + color1 * i_ColorRate.r;
    texCoord = vec4( i_TexCoord * uv_size + uv_src, 0, 1 );
}
