﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Types.h>
#include <nn/ui2d/ui2d_TexMap.h>
#include <nn/ui2d/ui2d_Common.h>

namespace nn
{
namespace ui2d
{

TexMap::TexMap()
: m_pTextureInfo(NULL)
{
    ResetSamplerSettings();
}

TexMap::TexMap(const TextureInfo* pTextureInfo)
: m_pTextureInfo(NULL)
{
    this->Set(pTextureInfo);
}

TexMap::~TexMap()
{
}

void TexMap::Finalize()
{
}

void
TexMap::SetWrapMode(TexWrap wrapS, TexWrap wrapT)
{
    NN_SDK_ASSERT(wrapS < TexWrap_MaxTexWrap);
    NN_SDK_ASSERT(wrapT < TexWrap_MaxTexWrap);

    m_Bits.wrapS = wrapS;
    m_Bits.wrapT = wrapT;
}

void
TexMap::SetFilter(TexFilter minFlt, TexFilter magFlt)
{
    NN_SDK_ASSERT(minFlt <= TexFilter_MaxTexFilter);
    NN_SDK_ASSERT(magFlt <= TexFilter_MaxTexFilter);

    m_Bits.minFilter = minFlt;
    m_Bits.magFilter = magFlt;
}

void
TexMap::Set(const TextureInfo* pCopySrc)
{
    NN_DETAIL_UI2D_WARNING(pCopySrc, "TextureInfo is NULL.\n");
    if (pCopySrc)
    {
        m_pTextureInfo = pCopySrc;
        ResetSamplerSettings();
    }
}

void
TexMap::CopySamplerSettings(const TexMap& texMap)
{
    m_Bits = texMap.m_Bits;
}

void
TexMap::ResetSamplerSettings()
{
    m_Bits.wrapS = TexWrap_Clamp;
    m_Bits.wrapT = TexWrap_Clamp;
    m_Bits.minFilter = TexFilter_Linear;
    m_Bits.magFilter = TexFilter_Linear;
}

} // namespace nn::ui2d
} // namespace nn
