﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Layout.h>
#include <nn/ui2d/ui2d_ControlCreator.h>
#include <nn/ui2d/ui2d_SelectButton.h>

namespace nn
{
namespace ui2d
{

void SelectButton::Build(nn::gfx::Device* pDevice, ui2d::Layout* pLayout, const ui2d::ControlSrc& controlSrc)
{
    AnimButton::Build(pDevice, pLayout, controlSrc);

    // Cancelアニメーションの取得
    nn::ui2d::Animator* pAnimator = pLayout->CreateGroupAnimatorAuto(pDevice, controlSrc.FindFunctionalAnimName("Cancel"), false);
    NN_SDK_ASSERT(pAnimator, "cannot create CancelAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Cancel"), pLayout->GetName());
    SetCancelAnimator(pAnimator);
}

bool SelectButton::IsHit(const nn::util::Float2& vec2) const
{
    // Cancelアニメーションを再生しているときは当たりが発生しないようにします。
    const State currentState = GetState();
    if (currentState == State_Cancel) {
        return false;
    } else {
        return AnimButton::IsHit(vec2);
    }
}

bool SelectButton::ProcessOff()
{
    // DOWN及びDOWN_IDLE状態でOffを受け付けないように修正します。
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        return true;
    case State_On:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Off:
        return true;
    case State_OnIdle:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Down:
        return true;
    case State_DownIdle:
        return true;
    case State_Cancel:
        return true;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

bool SelectButton::ProcessCancel()
{
    // Cancelイベントを受け付けるようにします。
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        return true;
    case State_On:
        return true;
    case State_Off:
        return true;
    case State_OnIdle:
        return true;
    case State_Down:
        return false;
    case State_DownIdle:
        ChangeState(State_Cancel);
        StartCancel();
        return true;
    case State_Cancel:
        return true;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

void SelectButton::FinishCancel()
{
    ChangeState(State_OffIdle);
    // OnOffアニメーションの状態をOFF_IDLEの状態に戻します。
    nn::ui2d::Animator* pAnimator = GetOnOffAnimator();
    if (pAnimator != NULL) {
        pAnimator->StopAtStartFrame();
    }
}

} // namespace nn::ui2d
} // namespace nn
