﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_DefaultControlCreator.h>
#include <nn/ui2d/ui2d_NormalButton.h>
#include <nn/ui2d/ui2d_DecisionButton.h>
#include <nn/ui2d/ui2d_SelectButton.h>
#include <nn/ui2d/ui2d_CheckButton.h>
#include <nn/ui2d/ui2d_TouchOffButton.h>
#include <nn/ui2d/ui2d_TouchOffCheckButton.h>
#include <nn/ui2d/ui2d_DragButton.h>
#include <nn/ui2d/ui2d_TouchDragButton.h>
#include <nn/ui2d/ui2d_Layout.h>

namespace nn
{
namespace ui2d
{

DefaultControlCreator::DefaultControlCreator(ButtonGroup* pButtonGroup)
: m_pButtonGroup(pButtonGroup)
{
}

void DefaultControlCreator::CreateControl(nn::gfx::Device* pDevice, ui2d::Layout* pLayout, const ui2d::ControlSrc& controlSrc)
{
    NN_SDK_ASSERT(m_pButtonGroup, "m_pButtonGroup must not be NULL for Layout[%s]", pLayout->GetName());

    if (!m_pButtonGroup)
    {
        return;
    }

    AnimButton* pButton = NULL;
    if (std::strcmp("NormalButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<NormalButton>();
        static_cast<NormalButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("DecisionButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<DecisionButton>();
        static_cast<DecisionButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("SelectButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<SelectButton>();
        static_cast<SelectButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("CheckButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<CheckButton>();
        static_cast<CheckButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("TouchOffButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<TouchOffButton>();
        static_cast<TouchOffButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("TouchOffCheckButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<TouchOffCheckButton>();
        static_cast<TouchOffCheckButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("DragButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<DragButton>();
        static_cast<DragButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    } else if (std::strcmp("TouchDragButton", controlSrc.GetControlName()) == 0) {
        pButton = ui2d::Layout::AllocateAndConstruct<TouchDragButton>();
        static_cast<TouchDragButton*>(pButton)->Build(pDevice, pLayout, controlSrc);
    }

    if (pButton) {
        m_pButtonGroup->GetButtonList().push_back(*pButton);
    }
}

} // namespace nn::ui2d
} // namespace nn
