﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_ControlCreator.h>
#include <nn/ui2d/ui2d_Resources.h>

namespace nn
{
namespace ui2d
{

ControlSrc::ControlSrc()
: m_pControlName(NULL)
, m_pControlUserName(NULL)
, m_FunctionalPaneCount(0)
, m_FunctionalAnimCount(0)
, m_pFunctionalPaneNames(NULL)
, m_pControlFunctionalAnimNameOffests(NULL)
, m_pControlFunctionalPaneParameterNameOffsets(NULL)
, m_pControlFunctionalAnimParameterNameOffsets(NULL)
, m_pExtUserDataList(NULL)
{
}

void ControlSrc::Initialize(const void* pData, const ResExtUserDataList* pUserDataBlock)
{
    const ResControl* pResControl = static_cast<const ResControl*>(pData);
    m_pControlName = nn::util::ConstBytePtr(pData, sizeof(ResControl)).Get<char>();
    m_pControlUserName = nn::util::ConstBytePtr(pData, pResControl->controlUserNameOffset).Get<char>();
    m_FunctionalPaneCount = pResControl->controlFunctionalPaneCount;
    m_FunctionalAnimCount = pResControl->controlFunctionalAnimCount;
    m_pFunctionalPaneNames = nn::util::ConstBytePtr(pData, pResControl->controlFunctionalPaneNamesOffset).Get<char>();
    m_pControlFunctionalAnimNameOffests = nn::util::ConstBytePtr(pData, pResControl->controlFunctionalPaneNamesOffset +
        m_FunctionalPaneCount * ResourceNameStrMax).Get<void>();
    m_pControlFunctionalPaneParameterNameOffsets = nn::util::ConstBytePtr(pData, pResControl->controlFunctionalPaneParameterNameOffsetsOffset).Get<void>();
    m_pControlFunctionalAnimParameterNameOffsets = nn::util::ConstBytePtr(pData, pResControl->controlFunctionalAnimParameterNameOffsetsOffset).Get<void>();
    m_pExtUserDataList = pUserDataBlock;
}

const char* ControlSrc::GetFunctionalPaneName(int  index) const
{
    if (index < GetFunctionalPaneCount()) {
        return &m_pFunctionalPaneNames[index * ResourceNameStrMax];
    } else {
        NN_SDK_ASSERT(false, "index exceeded [%d/%d]", index, GetFunctionalPaneCount());
        return NULL;
    }
}

const char* ControlSrc::FindFunctionalPaneName(const char* pParameterName) const
{
    for (uint32_t  i = 0; i < m_FunctionalPaneCount; i++) {
        const char* pName = nn::util::ConstBytePtr(m_pControlFunctionalPaneParameterNameOffsets,
            static_cast<const uint32_t*>(m_pControlFunctionalPaneParameterNameOffsets)[i]).Get<char>();
        if (std::strcmp(pName, pParameterName) == 0) {
            return &m_pFunctionalPaneNames[i * ResourceNameStrMax];
        }
    }
    return NULL;
}

const char* ControlSrc::GetFunctionalAnimName(int  index) const
{
    if (index < GetFunctionalAnimCount()) {
        return nn::util::ConstBytePtr(m_pControlFunctionalAnimNameOffests, static_cast<const uint32_t*>(m_pControlFunctionalAnimNameOffests)[index]).Get<char>();
    } else {
        NN_SDK_ASSERT(false, "index exceeded [%d/%d]", index, GetFunctionalAnimCount());
        return NULL;
    }
}

const char* ControlSrc::FindFunctionalAnimName(const char* pParameterName) const
{
    for (uint32_t  i = 0; i < m_FunctionalAnimCount; i++) {
        const char* pName = nn::util::ConstBytePtr(m_pControlFunctionalAnimParameterNameOffsets,
            static_cast<const uint32_t*>(m_pControlFunctionalAnimParameterNameOffsets)[i]).Get<char>();
        if (std::strcmp(pName, pParameterName) == 0) {
            return nn::util::ConstBytePtr(m_pControlFunctionalAnimNameOffests, static_cast<const uint32_t*>(m_pControlFunctionalAnimNameOffests)[i]).Get<char>();
        }
    }
    return NULL;
}

uint16_t
ControlSrc::GetExtUserDataCount() const
{
    if (! m_pExtUserDataList)
    {
        return 0;
    }

    return m_pExtUserDataList->count;
}

const ResExtUserData*
ControlSrc::GetExtUserDataArray() const
{
    if (! m_pExtUserDataList)
    {
        return 0;
    }

    return nn::util::ConstBytePtr(m_pExtUserDataList, sizeof(*m_pExtUserDataList)).Get<const ResExtUserData>();
}

const ResExtUserData*
ControlSrc::FindExtUserDataByName(const char* pName) const
{
    const ResExtUserData* pExtUserData = GetExtUserDataArray();
    if (! pExtUserData)
    {
        return 0;
    }

    for (int i = 0; i < m_pExtUserDataList->count; ++i, ++pExtUserData)
    {
        if (0 == std::strcmp(pName, pExtUserData->GetName()))
        {
            return pExtUserData;
        }
    }

    return 0;
}

} // namespace nn::ui2d
} // namespace nn
