﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/util/util_FormatString.h>
#include <nn/ige/ige_BufferWriter.h>
#include <nn/ige/ige_Slider.h>

namespace nn { namespace ige {

template <typename T>
Slider<T>::Slider(T* pValue, T min, T max, SliderOption option) NN_NOEXCEPT
    : Control(&m_Node, option)
{
    NN_SDK_REQUIRES_NOT_NULL(pValue);

    m_Min = min;
    m_Max = max;

    NodeOption nodeOption;
    nodeOption.pMetadataFunction = GenerateMetadata;
    nodeOption.pUserData = this;
    m_Node.Initialize(pValue, nodeOption);
}

template<>
void Slider<int>::GenerateMetadata(BufferWriter* pWriter, const Node& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<Slider<int>>();
    WriteAttribute(pWriter, "type", "Slider<int>");
    self.WriteCommonMetadata(pWriter);

    {
        char buffer[16] = {};
        ::nn::util::SNPrintf(buffer, NN_ARRAY_SIZE(buffer), "%d", self.m_Min);
        WriteAttribute(pWriter, "min", buffer);
    }

    {
        char buffer[16] = {};
        ::nn::util::SNPrintf(buffer, NN_ARRAY_SIZE(buffer), "%d", self.m_Max);
        WriteAttribute(pWriter, "max", buffer);
    }
}

template<>
void Slider<float>::GenerateMetadata(BufferWriter* pWriter, const Node& node) NN_NOEXCEPT
{
    auto& self = *node.GetUserData<Slider<float>>();
    WriteAttribute(pWriter, "type", "Slider<float>");
    self.WriteCommonMetadata(pWriter);

    {
        char buffer[16] = {};
        ::nn::util::SNPrintf(buffer, NN_ARRAY_SIZE(buffer), "%.9f", self.m_Min);
        WriteAttribute(pWriter, "min", buffer);
    }

    {
        char buffer[16] = {};
        ::nn::util::SNPrintf(buffer, NN_ARRAY_SIZE(buffer), "%.9f", self.m_Max);
        WriteAttribute(pWriter, "max", buffer);
    }
}

template class Slider<int>;
template class Slider<float>;

}} // namespace nn::ige::detail
