﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ige/ige_EditService.h>

#include <nn/ige/ige_CommandNode.h>
#include "detail/messages/ige_UserCommandMessage.h"

namespace nn { namespace ige {

CommandNode::CommandNode()
    : m_UserCommandReceivedFunc(NULL)
{
}

void CommandNode::Initialize(UserCommandReceivedFunction pFunc, NodeOption option) NN_NOEXCEPT
{
    m_UserCommandReceivedFunc = pFunc;
    Node::Initialize(option);
}

void CommandNode::Finalize() NN_NOEXCEPT
{
    m_UserCommandReceivedFunc = NULL;
    Node::Finalize();
}

void CommandNode::PushCommand(const BufferView& data) NN_NOEXCEPT
{
    GetService()->SendMessage(detail::UserCommandMessage(GetId(), data));
}

void CommandNode::OnDataMessageReceived(const detail::DataMessage& message) NN_NOEXCEPT
{
    if (message.GetType() == detail::MessageType_UserCommand)
    {
        const detail::UserCommandMessage& userCommand = static_cast<const detail::UserCommandMessage&>(message);
        if (m_UserCommandReceivedFunc != NULL)
        {
            m_UserCommandReceivedFunc(userCommand.GetData(), GetUserData(), *this);
        }
        return;
    }
}

}} // namespace nn::ige
