﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ige/ige_EditService.h>

#include <nn/ige/ige_CommandNode.h>
#include "detail/messages/ige_UserCommandMessage.h"

namespace nn { namespace ige {

CommandNode::CommandNode() NN_NOEXCEPT
    : m_pCommandReceivedFunc(NULL)
{
}

CommandNode::~CommandNode() NN_NOEXCEPT
{
    FinalizeCommandNode();
}

void CommandNode::Initialize(CommandReceivedFunction pFunc, NodeOption option) NN_NOEXCEPT
{
    Node::Initialize(option);
    m_pCommandReceivedFunc = pFunc;
}

void CommandNode::FinalizeCommandNode() NN_NOEXCEPT
{
    m_pCommandReceivedFunc = NULL;
}

void CommandNode::Finalize() NN_NOEXCEPT
{
    FinalizeCommandNode();
    Node::Finalize();
}

void CommandNode::PushCommand(const BufferView& data) NN_NOEXCEPT
{
    GetService()->SendMessage(detail::UserCommandMessage(GetId(), data));
}

void CommandNode::OnMessageReceived(const detail::NodeTargetMessage& message) NN_NOEXCEPT
{
    if (detail::UserCommandMessage::IsTarget(message.GetType()))
    {
        auto& userCommand = static_cast<const detail::UserCommandMessage&>(message);
        if (m_pCommandReceivedFunc != NULL)
        {
            m_pCommandReceivedFunc(userCommand.GetData(), *this);
        }
    }
    else
    {
        Node::OnMessageReceived(message);
    }
}

}} // namespace nn::ige
