﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"
#include "../ige_Version.h"

namespace nn { namespace ige { namespace detail {

class VersionMessage : public SystemMessage
{
public:
    explicit VersionMessage(Version version) NN_NOEXCEPT
        : m_Version(version)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_Version;
    }

    Version GetVersion() const NN_NOEXCEPT
    {
        return m_Version;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_Version;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

    static VersionMessage Read(const BufferView& buffer)
    {
        NN_SDK_REQUIRES(IsTarget(buffer));

        BufferReader reader(buffer);
        reader.ReadInt32(); // for MessageType

        uint32_t packed = reader.ReadUInt32();
        Version version = {};
        version.SetPacked(packed);
        return VersionMessage(version);
    }

protected:
    virtual void WritePacket(BufferWriter* pWriter) const NN_NOEXCEPT NN_OVERRIDE
    {
        pWriter->Write(m_Version.GetPacked());
    }

private:
    Version m_Version;
};

}}} // namespace nn::ige::detail
