﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"

namespace nn { namespace ige { namespace detail {

class MetadataRequestMessage : public NodeTargetMessage
{
public:
    explicit MetadataRequestMessage(NodeIdType id) NN_NOEXCEPT
        : NodeTargetMessage(id)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_MetadataRequest;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_MetadataRequest;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

    static MetadataRequestMessage Read(const BufferView& buffer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsTarget(buffer));

        BufferReader reader(buffer);
        reader.ReadInt32(); // for MessageType

        auto id = static_cast<NodeIdType>(reader.ReadUInt32());
        return MetadataRequestMessage(id);
    }
};

}}} // namespace nn::ige::detail
