﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"

namespace nn { namespace ige { namespace detail {

class MetadataMessage : public NodeTargetMessage
{
public:
    explicit MetadataMessage(NodeIdType id, const BufferView& metadata) NN_NOEXCEPT
        : NodeTargetMessage(id)
        , m_Metadata(metadata)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_Metadata;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_Metadata;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

protected:
    virtual void WritePacket(BufferWriter* pWriter) const NN_NOEXCEPT NN_OVERRIDE
    {
        pWriter->Write(m_Metadata);
    }

private:
    BufferView m_Metadata;
};

}}} // namespace nn::ige::detail
