﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ige/ige_NodeIdType.h>
#include "util/ige_IgeVector.h"
#include "ige_Allocator.h"

namespace nn { namespace ige {

class Node;

namespace detail {

class NodeIdManager
{
    NN_DISALLOW_COPY(NodeIdManager);
public:
    explicit NodeIdManager(IgeAllocator* pAllocator) NN_NOEXCEPT;

    NodeIdType Register(Node* pNode) NN_NOEXCEPT;
    bool Unregister(NodeIdType id) NN_NOEXCEPT;
    bool IsRegistered(NodeIdType id) const NN_NOEXCEPT;

    Node* Find(NodeIdType id) NN_NOEXCEPT;
    const Node* Find(NodeIdType id) const NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT;

private:
    NodeIdType GenerateId() NN_NOEXCEPT;
    int FindImpl(NodeIdType id) const NN_NOEXCEPT;

private:
    typedef IgeVector<Node*>::Type NodeVec;

    NodeVec m_Impl;
    NodeIdType m_LastGeneratedId;
};

}}} // namespace nn::ige::detail
