﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "g3d_ISynchronizable.h"
#include <nn/os/os_Mutex.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

class SynchronizedObject : public ISynchronizable
{
    NN_DISALLOW_COPY(SynchronizedObject);
public:
    void Lock() NN_NOEXCEPT
    {
        m_Mutex.Lock();
    }

    void Unlock() NN_NOEXCEPT
    {
        m_Mutex.Unlock();
    }

protected:
    SynchronizedObject() NN_NOEXCEPT
        : m_Mutex(true)
    {
    }
    virtual ~SynchronizedObject() NN_NOEXCEPT
    {
    }

    nn::os::Mutex& GetMutex() NN_NOEXCEPT
    {
        return m_Mutex;
    }

    const nn::os::Mutex& GetMutex() const NN_NOEXCEPT
    {
        return m_Mutex;
    }

private:
    nn::os::Mutex m_Mutex;
};

}}}} // namespace nn::g3d::viewer::detail
