﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../util/g3d_EditWorkBuffer.h"



#include <nn/g3d/detail/g3d_Inlines.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

bool EditWorkBuffer::ResizeImpl(size_t size) NN_NOEXCEPT
{
    if (size == 0)
    {
        Clear();
        return true;
    }

    void* newBuffer = m_pAllocator->Allocate(size, m_Alignment, m_AllocateType);
    if (newBuffer == nullptr)
    {
        return false;
    }

    if (m_pWorkBuffer != nullptr)
    {
        m_pAllocator->Free(m_pWorkBuffer);
    }

    m_pWorkBuffer = newBuffer;
    m_WorkBufferSize = size;
    return true;
}

bool
EditWorkBuffer::Resize(size_t size) NN_NOEXCEPT
{
    return ResizeImpl(size);
}

bool EditWorkBuffer::Resize(size_t size, size_t alignment) NN_NOEXCEPT
{
    m_Alignment = alignment;
    return ResizeImpl(size);
}

void
EditWorkBuffer::CopyFrom(const void* pBuffer, size_t size) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT((size % sizeof(Bit32)) == 0);
    NN_G3D_VIEWER_ASSERT(m_WorkBufferSize >= size);

    nn::g3d::detail::Copy32<false>(m_pWorkBuffer, pBuffer, static_cast<int>(size / sizeof(Bit32)));
}

}}}} // namespace nn::g3d::viewer::detail


