﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditShadingModel.h"



#include <nn/g3d/g3d_ResShader.h>
#include "../g3d_Allocator.h"
#include "g3d_EditShaderProgram.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {


EditShadingModel::EditShadingModel(
    nn::gfx::Device* pDevice,
    Allocator* allocator,
    ViewerKeyType shaderArchiveKey,
    int shadingModelIndex,
    ResShadingModel* resShadingModel,
    EditShaderArchive* pEditShaderArchive) NN_NOEXCEPT
    : DeviceDependentObj(pDevice, allocator)
    , m_pTargetResShadingModel(resShadingModel)
    , m_ShaderArchiveKey(shaderArchiveKey)
    , m_ShadingModelIndex(shadingModelIndex)
    , m_pEditShaderArchive(pEditShaderArchive)
    , m_pUpdateResShadingModel(nullptr)
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(allocator, "%s\n", NN_G3D_VIEWER_RES_NAME(resShadingModel, GetName()));
    NN_G3D_VIEWER_ASSERT_NOT_NULL(resShadingModel);
    resShadingModel->ToData().pCallbackParam.Set(this);

#if 0
    // TODO: 今後特に問題がでなければ消す
    m_pOriginalShaderInfo = resShadingModel->ToData().pShaderInfo.Get();
#endif
}

bool
EditShadingModel::Init() NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(m_pTargetResShadingModel);

    int shaderProgramCount = m_pTargetResShadingModel->GetShaderProgramCount();

    // 編集用のシェーダプログラムインスタンスを作成
    {
        size_t bufferSize = FixedSizeArray<EditShaderProgram>::CalculateBufferSize(shaderProgramCount);
        void* buffer = m_pAllocator->Allocate(bufferSize, nn::g3d::detail::Alignment_Default, AllocateType_EditObj);
        if (buffer == nullptr) // バッファ確保失敗
        {
            return false;
        }

        m_ShaderProgramArray.SetArrayBuffer(buffer, shaderProgramCount);
        for(int i = 0, end = m_ShaderProgramArray.GetCount(); i < end; ++i)
        {
            nn::g3d::ResShaderProgram* shaderProgram = m_pTargetResShadingModel->GetShaderProgram(i);
            EditShaderProgram* editShaderProgram = m_ShaderProgramArray.UnsafeAt(i);
            new (editShaderProgram) EditShaderProgram(m_pDevice, m_pAllocator, m_ShaderArchiveKey, m_ShadingModelIndex, i, shaderProgram);
        }
    }
    return true;
}

void EditShadingModel::UpdateShadingModel(ResShaderArchive* resShaderArchive) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(resShaderArchive);
    NN_G3D_VIEWER_ASSERT(resShaderArchive->GetShadingModelCount() > 0);

#if 0
    // TODO: 今後特に問題がでなければ消す
    ResShadingModel* resShadingModel = resShaderArchive->GetShadingModel(0);
    if(m_pUpdateResShadingModel)
    {
        m_pUpdateResShadingModel->Cleanup(m_pDevice);
    }
    m_pUpdateResShadingModel = resShadingModel;
    m_pUpdateResShadingModel->Setup(m_pDevice);
    m_pTargetResShadingModel->ToData().pShaderInfo.Set(resShadingModel->ToData().pShaderInfo.Get());
#else
    NN_UNUSED(resShaderArchive);
#endif
}

void
EditShadingModel::ResetToOriginal() NN_NOEXCEPT
{
#if 0
    // TODO: 今後特に問題がでなければ消す
    if(m_pUpdateResShadingModel)
    {
        m_pUpdateResShadingModel->Cleanup(m_pDevice);
        m_pUpdateResShadingModel = nullptr;
    }
    m_pTargetResShadingModel->ToData().pShaderInfo.Set(reinterpret_cast<nn::g3d::ResShaderInfo*>(m_pOriginalShaderInfo));
#endif

    {
        int size = m_ShaderProgramArray.GetCount();
        for (int i = 0; i < size; ++i)
        {
            EditShaderProgram* editShaderProgram = m_ShaderProgramArray.UnsafeAt(i);
            editShaderProgram->ResetToOriginal();
        }
    }
}

void
EditShadingModel::Destroy() NN_NOEXCEPT
{
    {
        int size = m_ShaderProgramArray.GetCount();
        for (int i = 0; i < size; ++i)
        {
            EditShaderProgram* editShaderProgram = m_ShaderProgramArray.UnsafeAt(i);
            editShaderProgram->Destroy();
        }
        void* buffer = m_ShaderProgramArray.GetBufferPtr();
        if (buffer != nullptr)
        {
            m_ShaderProgramArray.Clear();
            m_pAllocator->Free(buffer);
        }
    }
}

void EditShadingModel::SendModifiedShaderPrograms(EditSocketBase* pSocket) NN_NOEXCEPT
{
    ScopedLock scopedLock(m_ShaderProgramArray);
    for (int programIndex = 0, shaderProgramCount = m_ShaderProgramArray.GetCount(); programIndex < shaderProgramCount; ++programIndex)
    {
        EditShaderProgram* pShaderProgram = m_ShaderProgramArray.UnsafeAt(programIndex);
        pShaderProgram->SendModifiedShaderProgram(pSocket);
    }
}

}}}} // namespace nn::g3d::viewer::detail


