﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/g3d/viewer/g3d_ViewerDefine.h>


#include <nn/g3d/g3d_SkeletonObj.h>
#include "../util/g3d_FixedSizeArray.h"
#include "../util/g3d_EditWorkBufferSwitcher.h"
#include "../g3d_DeviceDependentObj.h"
#include <nn/gfx/gfx_MemoryPool.h>

namespace nn { namespace g3d {

class ModelObj;
class SkeletonObj;
class ResSkeleton;

namespace viewer {
namespace detail {

class Allocator;

/**
    @briefprivate 編集対象スケルトンクラスです。
 */
class EditSkeletonObj : DeviceDependentObj
{
public:
    explicit EditSkeletonObj(
        nn::g3d::ModelObj* ownerModelObj, nn::g3d::SkeletonObj* pSkeletonObj,
        nn::gfx::Device* pDevice, Allocator* pAllocator) NN_NOEXCEPT;
    ~EditSkeletonObj() NN_NOEXCEPT;

    void ClearBuffers() NN_NOEXCEPT;

    void ResetToOriginal() NN_NOEXCEPT;

    bool IsOriginal() const NN_NOEXCEPT
    {
        return m_WorkBuffer.GetSize() == 0;
    }

    size_t CalculateBlockBufferSize(const nn::g3d::ResSkeleton* pResSkeleton) const NN_NOEXCEPT;
    size_t GetBlockBufferAlignment(const nn::g3d::ResSkeleton* pResSkeleton) const NN_NOEXCEPT;
    void SetupSkeletonInstance(
        nn::g3d::ResSkeleton* pResSkeleton,
        nn::gfx::MemoryPool* pMemoryPool,
        ptrdiff_t memoryPoolOffset,
        size_t memoryPoolSize) NN_NOEXCEPT;

    void SwitchBlockBuffer() NN_NOEXCEPT;

private:
    nn::g3d::ModelObj*          m_pOwnerModelObj;
    nn::g3d::SkeletonObj*       m_pSkeletonObj;
    nn::g3d::ResSkeleton*       m_pOriginalResSkeleton;

    void*                       m_pOriginalBuffer;
    size_t                      m_OriginalBufferSize;

    nn::gfx::MemoryPool*        m_pOriginalBlockMemoryPool;
    ptrdiff_t                   m_OriginalBlockMemoryPoolOffset;
    size_t                      m_OriginalBlockBufferSize;

    int                         m_OriginalBufferingCount;
    nn::gfx::Buffer* m_pOriginalBlockBufferArray;

    EditWorkBuffer              m_WorkBuffer;
    EditWorkBufferSwitcher m_BlockBufferObjectManager;

private:
    NN_DISALLOW_COPY(EditSkeletonObj);
};

}}
}}

