﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../util/g3d_EditWorkBuffer.h"

namespace nn {
namespace util {
class ResDic;
}
namespace g3d {

class MaterialObj;
class ResMaterial;
class ResRenderInfo;

namespace viewer {
namespace detail {

class Allocator;
class EditMaterialObj;

class EditRenderInfoObj
{
public:
    EditRenderInfoObj(
        Allocator* allocator,
        nn::g3d::MaterialObj* ownerMaterialObj) NN_NOEXCEPT;

    void Cleanup() NN_NOEXCEPT;

    void Destroy() NN_NOEXCEPT;

    void SetUpdateMaterial(nn::g3d::ResMaterial* resMaterial) NN_NOEXCEPT;
    void Update(
        const void* pRenderInfoUpdateCommandData, size_t renderInfoUpdateCommandDataSize,
        ptrdiff_t renderInfoArrayOffset) NN_NOEXCEPT;
private:

    Allocator* m_pAllocator;

    nn::g3d::MaterialObj* m_pOwnerMaterial;
    nn::g3d::ResMaterial* m_pOriginalMaterial;
    nn::util::ResDic* m_pOriginalRenderInfoDic;
    ResRenderInfo* m_pOriginalRenderInfoArray;
    uint16_t m_OriginalRenderInfoCount;
    EditWorkBuffer m_RenderInfoDicWorkBuffer;

    nn::g3d::ResMaterial* m_pUpdatedMaterial;
    nn::util::ResDic* m_pUpdatedRenderInfoDic;
    ResRenderInfo* m_pUpdatedRenderInfoArray;
    uint16_t m_UpdateRenderInfoCount;

    NN_DISALLOW_COPY(EditRenderInfoObj);
};

}}}} // namespace nn::g3d::edit::detail


