﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



namespace nn { namespace g3d {

class ModelObj;
class SkeletonObj;
class ResBone;

namespace viewer {
namespace detail {

class Allocator;
class EditSkeletonObj;

/**
    @briefprivate 編集対象ボーンクラスです。
 */
class EditBone
{
public:
    explicit EditBone(
        int index,
        nn::g3d::SkeletonObj* ownerSkeletonObj,
        nn::g3d::ResBone* resBone) NN_NOEXCEPT
        : m_Index(index)
        , m_pOwnerSkeleton(ownerSkeletonObj)
        , m_pBone(resBone)
        , m_Flag(0)
    {}

    void Setup() NN_NOEXCEPT;
    void Cleanup() NN_NOEXCEPT;

    void SetBillboardFlag(Bit32 flag) NN_NOEXCEPT;
    void SetVisibilityFlag(bool enable) NN_NOEXCEPT;

private:
    int m_Index;
    nn::g3d::SkeletonObj* m_pOwnerSkeleton;
    nn::g3d::ResBone* m_pBone;

    Bit32 m_Flag;

private:
    NN_DISALLOW_COPY(EditBone);
};

}}
}}

