﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditBone.h"



#include <nn/g3d/g3d_ResSkeleton.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {


static const Bit32 VISIBILITY_CLEAR_MASK = static_cast<Bit32>(~ResBone::Flag_Visibility);
static const Bit32 BILLBOARD_CLEAR_MASK = static_cast<Bit32>(~ResBone::Flag_BillboardMax);

void EditBone::Setup() NN_NOEXCEPT
{
    // 初期状態を退避
    m_Flag = m_pBone->ToData().flag & (ResBone::Flag_Visibility | ResBone::Flag_BillboardMax);
}

void EditBone::Cleanup() NN_NOEXCEPT
{
    // 初期状態に戻す
    Bit32 clearFlag = VISIBILITY_CLEAR_MASK | BILLBOARD_CLEAR_MASK;
    m_pBone->ToData().flag &= clearFlag;
    m_pBone->ToData().flag |= m_Flag;
}

void EditBone::SetBillboardFlag(Bit32 flag) NN_NOEXCEPT
{
    m_pBone->ToData().flag &= BILLBOARD_CLEAR_MASK;
    m_pBone->ToData().flag |= flag;
}

void EditBone::SetVisibilityFlag(bool enable) NN_NOEXCEPT
{
    m_pBone->ToData().flag &= VISIBILITY_CLEAR_MASK;
    if (enable)
    {
        m_pBone->ToData().flag |= ResBone::Flag_Visibility;
    }
}

}}}}

