﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../g3d_DeviceDependentObj.h"

namespace nn { namespace g3d {
namespace viewer {
namespace detail {

/**
    @briefprivate 点滅可能な抽象オブジェクトクラスです。
*/
class BlinkingObj : public DeviceDependentObj
{
public:
    BlinkingObj(nn::gfx::Device* pDevice, Allocator* pAllocator) NN_NOEXCEPT
        : DeviceDependentObj(pDevice, pAllocator)
        , m_RestFrameCountForBlinking(0)
        , m_IsVisible(false)
    {
    }
    virtual ~BlinkingObj() NN_NOEXCEPT
    {
    }

    // @brief 点滅を開始します。
    void StartBlinking() NN_NOEXCEPT;

    // @brief 点滅状態を更新します。
    // @return シェイプに更新が行われた場合は true、そうでない場合は false を返します。
    bool UpdateBlinking() NN_NOEXCEPT;

    // @biref 点滅を強制的に終了します。
    void BreakBlinking() NN_NOEXCEPT;

    // @biref 点滅中であればtrue、そうでなければfalseを返します。
    bool IsBlinking() const NN_NOEXCEPT
    {
        return m_RestFrameCountForBlinking > 0;
    }

private:
    // @brief 表示状態にする処理を記述します。
    virtual void Show() = 0;

    // @brief 非表示状態にする処理を記述します。
    virtual void Hide() = 0;

    // @brief 通常は表示状態であるかどうかを記述します。
    virtual bool IsVisibleByDefault() const = 0;

private:
    int m_RestFrameCountForBlinking;
    bool m_IsVisible;

private:
    NN_DISALLOW_COPY(BlinkingObj);
};

}}
}}



