﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_NotifyMessageCommand.h"

#include "../g3d_EditSocket.h"
#include "../g3d_ViewerDetailDefine.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

using namespace nn::g3d::viewer::detail;

nn::g3d::viewer::detail::NotifyMessageCommand::NotifyMessageCommand(
    Allocator* pAllocator,
    const nn::util::string_view& message,
    int messageCodePage,
    MessageType messageType,
    ViewerServer::SendUserMessageArg::MessageDestination messageDestination) NN_NOEXCEPT
    : m_pAllocator(pAllocator)
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(pAllocator);
    NN_G3D_VIEWER_ASSERT_DETAIL(message.length() > 0, "Message length must be greater than zero.");

    size_t messageDataSize = message.length() * sizeof(char) + 1;
    m_PacketSize = nn::util::align_up(sizeof(MessageNotificationPacket) + messageDataSize, DefaultAlignment);
    void* pPacketBuffer = m_pAllocator->Allocate(m_PacketSize, DefaultAlignment, AllocateType_Communication);
    NN_G3D_VIEWER_ASSERT_NOT_NULL(pPacketBuffer);

    m_pMessageNotificationPacket = new (pPacketBuffer) MessageNotificationPacket;
    m_pMessageNotificationPacket->header.command = OTHER_USER_MESSAGE_COMMAND_FLAG;
    m_pMessageNotificationPacket->header.dataSize = static_cast<int32_t>(m_PacketSize - sizeof(PacketHeader));
    m_pMessageNotificationPacket->header.magic = NN_G3D_EDIT_MAGIC;
    m_pMessageNotificationPacket->header.verWord = NN_G3D_EDIT_VERSION;
    m_pMessageNotificationPacket->info.messageType = static_cast<int32_t>(messageType);
    m_pMessageNotificationPacket->info.messageDestination = static_cast<int32_t>(messageDestination);
    m_pMessageNotificationPacket->info.messageDataSize = static_cast<int32_t>(messageDataSize);
    m_pMessageNotificationPacket->info.messageCodePage = static_cast<int32_t>(messageCodePage);
    memcpy(m_pMessageNotificationPacket->info.message, message.data(), messageDataSize);
    m_pMessageNotificationPacket->info.message[messageDataSize - 1] = '\0';
}

nn::g3d::viewer::detail::NotifyMessageCommand::~NotifyMessageCommand() NN_NOEXCEPT
{
    m_pMessageNotificationPacket->~MessageNotificationPacket();
    m_pAllocator->Free(m_pMessageNotificationPacket);
}

CommandResult nn::g3d::viewer::detail::NotifyMessageCommand::Execute(EditSocketBase* pSocket) NN_NOEXCEPT
{
    NN_G3D_VIEWER_DEBUG_PRINT("Write NotifyMessageCommand\n");
    if (!pSocket->WriteSync(m_pMessageNotificationPacket, m_PacketSize))
    {
        return CommandResult_Failed;
    }

    return CommandResult_Success;
}
