﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"
#include "g3d_IViewerCommand.h"
#include "g3d_CommandTypes.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {
    class FileLoadedCommand : public IViewerCommand
    {
    public:
        //! @brief アニメーションやテクスチャのロード用コンストラクタです。
        FileLoadedCommand(
            ViewerKeyType resFileKey,
            ViewerKeyType toolKey,
            FileDataKind kind) NN_NOEXCEPT;

        //! @brief アニメーションやテクスチャのリロード用コンストラクタです。
        FileLoadedCommand(
            ViewerKeyType resFileKey,
            ViewerKeyType newResFileKey,
            ViewerKeyType toolKey,
            FileDataKind kind) NN_NOEXCEPT;

        //! @brief モデルのロード用コンストラクタです。
        FileLoadedCommand(
            ViewerKeyType resModelKey,
            ViewerKeyType resFileKey,
            ViewerKeyType firstLoadedResFileKey,
            ViewerKeyType toolKey) NN_NOEXCEPT;

        //! @brief モデルのリロード用コンストラクタです。
        FileLoadedCommand(
            ViewerKeyType resModelKey, ViewerKeyType modelObjKey,
            ViewerKeyType resFileKey, ViewerKeyType newResFileKey, ViewerKeyType toolKey) NN_NOEXCEPT;

        ~FileLoadedCommand() NN_NOEXCEPT;

        virtual CommandResult Execute(EditSocketBase* pSocket) NN_NOEXCEPT;

        virtual int Type() const NN_NOEXCEPT
        {
            return CommandType_FileLoaded;
        }

        ViewerKeyType GetResModelKey() const NN_NOEXCEPT
        {
            return m_FileLoadedPacket.block.resModelKey;
        }

        void SetModelObjKey(ViewerKeyType modelObjKey) NN_NOEXCEPT
        {
            m_FileLoadedPacket.block.modelObjKey = modelObjKey;
        }

        //! @brief ロードモデル時に 3DEditor から初回ロードしたモデルを識別するためのキーを取得します。
        ViewerKeyType GetFirstLoadResFileKey() const NN_NOEXCEPT
        {
            return m_FirstLoadResFileKey;
        }

    private:
        void InitializePacket() NN_NOEXCEPT;

        FileLoadedPacket m_FileLoadedPacket;

        // ロードモデル時に 3DEditor から初回送られてきたモデルを取得するために保持
        ViewerKeyType m_FirstLoadResFileKey;
    };
}}}}
