﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"
#include "../util/g3d_ViewerUtility.h"
#include "../util/g3d_DynamicLengthString.h"
#include "../util/g3d_DynamicArray.h"
#include "g3d_IViewerCommand.h"
#include "g3d_CommandTypes.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

namespace nn { namespace g3d {

class ResShaderArchive;
class ResModel;

namespace viewer { namespace detail {

class Allocator;
class EditCommandManager;

class AttachCommand : public IViewerCommand
{
    NN_DISALLOW_COPY(AttachCommand);
public:
    enum ExecuteState
    {
        ExecuteState_WaitPreprocess,
        ExecuteState_WaitExecute,
        ExecuteState_WaitPostprocess,
        ExecuteState_Finish,
        ExecuteState_ImpossibleToContinue,
    };

    AttachCommand(
        EditCommandManager* pEditCommandManager,
        Allocator* pAllocator,
        size_t alignment,
        ViewerKeyType key,
        AttachKind kind,
        const char* path) NN_NOEXCEPT;
    ~AttachCommand() NN_NOEXCEPT;

    virtual int Type() const NN_NOEXCEPT
    {
        return CommandType_Attach;
    }

    nn::g3d::ModelObj* GetModelObj(int index) NN_NOEXCEPT
    {
        return m_ModelObjs[index];
    }

    const nn::g3d::ModelObj* GetModelObj(int index) const NN_NOEXCEPT
    {
        return m_ModelObjs[index];
    }

    int GetModelObjCount() const NN_NOEXCEPT
    {
        return m_ModelObjs.GetCount();
    }

    void PushBack(nn::g3d::ModelObj* pModelObj) NN_NOEXCEPT
    {
        m_ModelObjs.PushBack(pModelObj);
    }

    nn::g3d::ModelObj** GetModelObjArrayData() NN_NOEXCEPT
    {
        return m_ModelObjs.GetData();
    }

    //! @brief メインスレッドと同期で実行する必要のある前処理です。
    void ExecutePreprocess() NN_NOEXCEPT;

    //! @brief メインスレッドと同期で実行する必要のある後処理です。
    void ExecutePostprocess() NN_NOEXCEPT;

    //! @brief メインスレッドと非同期で実行できる処理です。
    virtual CommandResult Execute(EditSocketBase* pSocket) NN_NOEXCEPT;

    ExecuteState GetExecuteState() const NN_NOEXCEPT
    {
        return m_ExecuteState;
    }

    RuntimeErrorCode GetLastError() const NN_NOEXCEPT
    {
        return m_LastErrorCode;
    }

    const nn::g3d::ResModel* GetResModel() const NN_NOEXCEPT
    {
        return m_Resource.pResModel;
    }

    void SetResModel(const nn::g3d::ResModel* pResModel) NN_NOEXCEPT
    {
        m_Resource.pResModel = pResModel;
    }

    const nn::g3d::ResShaderArchive* GetResShaderArchive() const NN_NOEXCEPT
    {
        return m_Resource.pResShaderArchive;
    }

    void SetResShaderArchive(const nn::g3d::ResShaderArchive* pResShaderArchive) NN_NOEXCEPT
    {
        m_Resource.pResShaderArchive = pResShaderArchive;
    }

    AttachKind GetKind() const NN_NOEXCEPT
    {
        return m_Kind;
    }

    ViewerKeyType GetKey() const NN_NOEXCEPT
    {
        return m_Key;
    }

private:
    void SetPacketName(const char* name) NN_NOEXCEPT;

    union
    {
        const nn::g3d::ResModel* pResModel;
        const nn::g3d::ResShaderArchive *pResShaderArchive;
    } m_Resource;

    ViewerKeyType m_Key;
    AttachKind m_Kind;
    DynamicLengthString* m_Path;

    EditCommandManager* m_pEditCommandManager;
    DynamicArray<nn::g3d::ModelObj*> m_ModelObjs;
    size_t m_Alignment;
    Allocator* m_pAllocator;

    ExecuteState m_ExecuteState;
    AttachPacket m_AttachPacket;
    RuntimeErrorCode m_LastErrorCode;
};
}}
}}
