﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "g3d_EditAnimObj.h"
#include "../util/g3d_DynamicArray.h"


namespace nn {
namespace g3d {

    class ModelAnimObj;
    class ResFile;

    namespace viewer { namespace detail {
        class Allocator;

        class EditTexPatternAnimObj : public EditAnimObj
        {
        public:
            explicit EditTexPatternAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile) NN_NOEXCEPT
                : EditAnimObj(pAllocator, pResFile, ViewerAnimKind_TexturePatternAnim)
                , m_pMatAnimArray(nullptr)
                , m_MatAnimCount(0)
                , m_BoundTextureKeys(pAllocator, Alignment_Default, InvalidKey)
            {
            }

            virtual ~EditTexPatternAnimObj() NN_NOEXCEPT
            {
                UnbindAllModelObjs();
                DestroyDataForEditingAnimCurve();
            }

            virtual bool CreateDataForEditingAnimCurve() NN_NOEXCEPT;
            virtual void DestroyDataForEditingAnimCurve() NN_NOEXCEPT;

            void EditCurve(
                int matAnimIndex,
                int curveIndex,
                const nn::g3d::ResAnimCurve* resAnimCurve) NN_NOEXCEPT;

            bool ExaminesTextureFileUsed(const nn::gfx::ResTextureFile* pResTextureFile) const NN_NOEXCEPT;
            void ReloadTexture(const nn::gfx::ResTextureFile* pOldResTextureFile, const nn::gfx::ResTextureFile* pNewResTextureFile, CallbackCaller& callback) NN_NOEXCEPT;
            void ForceBindTexture(const nn::gfx::ResTextureFile* pResTextureFile, CallbackCaller& callback) NN_NOEXCEPT;
            void UnbindTexture(const nn::gfx::ResTextureFile* pResTextureFile, CallbackCaller& callback) NN_NOEXCEPT;

            bool ExaminesTextureBindable(ViewerKeyType textureKey) const NN_NOEXCEPT
            {
                return m_BoundTextureKeys.Contains(textureKey);
            }

            void UpdateTextureBindings(TextureBindingBlock* pBlock) NN_NOEXCEPT
            {
                m_BoundTextureKeys.Clear();
                for (int index = 0; index < pBlock->textureKeyArrayCount; ++index)
                {
                    m_BoundTextureKeys.PushBack(static_cast<ViewerKeyType>(pBlock->textureKeyArrayData[index]));
                }
            }

        protected:
            virtual BindResult SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT;
            virtual void ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT;
            virtual ModelAnimObj* CreateAnimObj() NN_NOEXCEPT;

        private:
            class EditTexPatternMatAnim;

            EditTexPatternMatAnim*   m_pMatAnimArray;
            int                      m_MatAnimCount;

            // バインドを行うテクスチャのキー配列
            DynamicArray<ViewerKeyType> m_BoundTextureKeys;

        private:
            NN_DISALLOW_COPY(EditTexPatternAnimObj);
        };
    }}
}}

