﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>


#include <nn/gfx/gfx_Core.h>

#include "g3d_EditAnimObj.h"

namespace nn { namespace g3d {

class ModelAnimObj;
class ResFile;
class ResSkeletalAnim;

namespace viewer {
namespace detail {

class Allocator;

class EditSkeletalAnimObj : public EditAnimObj
{
public:
    explicit EditSkeletalAnimObj(
        Allocator* pAllocator,
        nn::g3d::ResFile* pResFile) NN_NOEXCEPT
        : EditAnimObj(pAllocator, pResFile, ViewerAnimKind_SkeletalAnim)
        , m_pRetargetingHostModel(nullptr)
        , m_MotionMirroringEnabled(false)
    {
    }

    virtual ~EditSkeletalAnimObj() NN_NOEXCEPT
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual void ApplyAnimTo(EditModelObj* pEditModelObj) NN_NOEXCEPT
    {
        SkeletalAnimObj* pSkeletalAnimObj = GetSkeletalAnimObj(pEditModelObj);
        for (int index = 0, count = pEditModelObj->GetAttachedModelObjCount(); index < count; ++index)
        {
            ModelObj* pModelObj = pEditModelObj->GetTargetModelObj(index);
            pSkeletalAnimObj->ApplyTo(pModelObj->GetSkeleton());
        }
    }

    virtual bool CreateDataForEditingAnimCurve() NN_NOEXCEPT;
    virtual void DestroyDataForEditingAnimCurve() NN_NOEXCEPT;

    void RebindAnim() NN_NOEXCEPT
    {
        for (int modelIndex = 0, end = GetBoundEditModelObjCount(); modelIndex < end; ++modelIndex)
        {
            EditModelObj* pBoundEditModelObj = GetBoundEditModelObj(modelIndex);
            for (int instanceIndex = 0, instanceCount = pBoundEditModelObj->GetAttachedModelObjCount();
                instanceIndex < instanceCount; ++instanceIndex)
            {
                ModelObj* pBoundModelObj = pBoundEditModelObj->GetTargetModelObj(instanceIndex);
                if (m_SetupFlag && pBoundModelObj)
                {
                    SkeletalAnimObj* pSkeletalAnimObj = GetSkeletalAnimObj(modelIndex);
                    nn::g3d::SkeletalAnimObj::BindArgument bindArg;
                    bindArg.SetResource(pBoundModelObj->GetSkeleton()->GetResource());
                    if (m_MotionMirroringEnabled && pBoundModelObj->GetSkeleton()->GetResource()->HasMirroringInfo())
                    {
                        bindArg.SetMirroringEnabled();
                    }
                    if (m_pRetargetingHostModel)
                    {
                        bindArg.SetHostResource(m_pRetargetingHostModel->GetSkeleton()->GetResource());
                        bindArg.SetRetargetingEnabled();
                    }
                    pSkeletalAnimObj->Bind(bindArg);
                }
            }
        }
    }

    void SetRetargetingHostModel(const ModelObj* pRetargetHostModelObj) NN_NOEXCEPT
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(pRetargetHostModelObj);
        m_pRetargetingHostModel = pRetargetHostModelObj;
        RebindAnim();
    }

    void UnsetRetargetingHostModel() NN_NOEXCEPT
    {
        m_pRetargetingHostModel = nullptr;
        RebindAnim();
    }

    void SetPlayMotionMirroringEnabled(bool isEnabled) NN_NOEXCEPT
    {
        m_MotionMirroringEnabled = isEnabled;
        RebindAnim();
    }

    const ModelObj* GetRetargetingHostModel() const NN_NOEXCEPT
    {
        return m_pRetargetingHostModel;
    }

protected:
    SkeletalAnimObj* GetSkeletalAnimObj(EditModelObj* pEditModelObj) NN_NOEXCEPT
    {
        return static_cast<SkeletalAnimObj*>(GetAssociatedAnimObj(pEditModelObj));
    }

    SkeletalAnimObj* GetSkeletalAnimObj(int index) NN_NOEXCEPT
    {
        return static_cast<SkeletalAnimObj*>(GetAnimObj(index));
    }

    virtual void ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT;
    virtual ModelAnimObj* CreateAnimObj() NN_NOEXCEPT
    {
        void* buffer = m_pAllocator->Allocate(sizeof(SkeletalAnimObj), nn::g3d::detail::Alignment_Default, AllocateType_Obj);
        SkeletalAnimObj* pSkeletalAnimObj = new (buffer) SkeletalAnimObj();
        return pSkeletalAnimObj;
    }

protected:
    virtual BindResult SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT;

private:
    const ModelObj*             m_pRetargetingHostModel;
    bool                        m_MotionMirroringEnabled;

private:
    NN_DISALLOW_COPY(EditSkeletalAnimObj);
};


}}}}

