﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "g3d_EditAnimObj.h"
#include "g3d_EditAnimCurve.h"

namespace nn { namespace g3d {

class ModelAnimObj;
class ResFile;

namespace viewer {
namespace detail {

class Allocator;

class EditShapeAnimObj : public EditAnimObj
{
public:
    explicit EditShapeAnimObj(Allocator* pAllocator, nn::g3d::ResFile* pResFile) NN_NOEXCEPT
        : EditAnimObj(pAllocator, pResFile, ViewerAnimKind_ShapeAnim)
        , m_pEditVertexShapeAnimArray(nullptr)
        , m_EditVertexShapeAnimCount(0)
    {
    }

    virtual ~EditShapeAnimObj() NN_NOEXCEPT
    {
        UnbindAllModelObjs();
        DestroyDataForEditingAnimCurve();
    }

    virtual bool CreateDataForEditingAnimCurve() NN_NOEXCEPT;
    virtual void DestroyDataForEditingAnimCurve() NN_NOEXCEPT;
    void EditCurve(
        int animIndex,
        int curveIndex,
        const nn::g3d::ResAnimCurve* resAnimCurve) NN_NOEXCEPT;

protected:
    virtual BindResult SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT;
    virtual void ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT;
    virtual ModelAnimObj* CreateAnimObj() NN_NOEXCEPT
    {
        void* buffer = m_pAllocator->Allocate(sizeof(ShapeAnimObj), nn::g3d::detail::Alignment_Default, AllocateType_Obj);
        ShapeAnimObj* pAnimObj = new (buffer) ShapeAnimObj();
        return pAnimObj;
    }

private:
    class EditVertexShapeAnim
    {
    public:
        explicit EditVertexShapeAnim(Allocator* allocator, ResVertexShapeAnim* resVertexShapeAnim) NN_NOEXCEPT
            : m_pAllocator(allocator)
            , m_pResVertexShapeAnim(resVertexShapeAnim)
            , m_pEditAnimCurveArray(nullptr)
            , m_EditAnimCurveCount(0)
        {
            NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(allocator, "%s\n", NN_G3D_VIEWER_RES_NAME(m_pResVertexShapeAnim, GetName()));
            NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(resVertexShapeAnim, "%s\n", NN_G3D_VIEWER_RES_NAME(m_pResVertexShapeAnim, GetName()));
        }

        bool Init() NN_NOEXCEPT;
        void Destroy() NN_NOEXCEPT;

        EditAnimCurve* GetEditAnimCurve(int index) NN_NOEXCEPT
        {
            return &m_pEditAnimCurveArray[index];
        }
        int GetEditAnimCurveCount() const NN_NOEXCEPT
        {
            return m_EditAnimCurveCount;
        }

    private:
        ResVertexShapeAnim* GetResource() NN_NOEXCEPT
        {
            return m_pResVertexShapeAnim;
        }

    private:
        Allocator*             m_pAllocator;
        ResVertexShapeAnim*     m_pResVertexShapeAnim;
        EditAnimCurve*          m_pEditAnimCurveArray;
        int                     m_EditAnimCurveCount;

    private:
        NN_DISALLOW_COPY(EditVertexShapeAnim);
    };

    EditVertexShapeAnim*        m_pEditVertexShapeAnimArray;
    int                         m_EditVertexShapeAnimCount;

private:
    NN_DISALLOW_COPY(EditShapeAnimObj);
};

}}}} // namespace nn::g3d::edit::detail


