﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditShapeAnimObj.h"



#include "../g3d_Allocator.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

bool
EditShapeAnimObj::EditVertexShapeAnim::Init() NN_NOEXCEPT
{
    int curveCount = m_pResVertexShapeAnim->GetCurveCount();
    size_t bufferSize = sizeof(EditAnimCurve) * curveCount;

    void* buffer = m_pAllocator->Allocate(bufferSize, nn::g3d::detail::Alignment_Default, AllocateType_EditObj);
    if (buffer == nullptr)
    {
        return false;
    }
    m_pEditAnimCurveArray = static_cast<EditAnimCurve*>(buffer);
    m_EditAnimCurveCount = curveCount;

    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        nn::g3d::ResAnimCurve* resAnimCurve =
            m_pResVertexShapeAnim->GetCurve(i);

        EditAnimCurve* editAnimCurve = new(&m_pEditAnimCurveArray[i]) EditAnimCurve(m_pAllocator, resAnimCurve);
        editAnimCurve->Setup();
    }
    return true;
}

void
EditShapeAnimObj::EditVertexShapeAnim::Destroy() NN_NOEXCEPT
{
    for(int i = 0; i < m_EditAnimCurveCount; ++i)
    {
        EditAnimCurve* editAnimCurve = &m_pEditAnimCurveArray[i];
        editAnimCurve->Cleanup();
        editAnimCurve->~EditAnimCurve();
    }

    if (m_pEditAnimCurveArray != nullptr)
    {
        m_pAllocator->Free(m_pEditAnimCurveArray);
        m_pEditAnimCurveArray = nullptr;
    }
}

/*virtual*/void
EditShapeAnimObj::ResetToOriginalValue(EditModelObj* pBoundModelObj) NN_NOEXCEPT
{
    NN_UNUSED(pBoundModelObj);
}

/*virtual*/bool
EditShapeAnimObj::CreateDataForEditingAnimCurve() NN_NOEXCEPT
{
    ResShapeAnim* pResAnim = static_cast<ResShapeAnim*>(GetResAnim());
    int animCount = pResAnim->GetVertexShapeAnimCount();
    size_t bufferSize = sizeof(EditShapeAnimObj::EditVertexShapeAnim) * animCount;

    void* buffer = nullptr;
    if (bufferSize > 0)
    {
        buffer = m_pAllocator->Allocate(bufferSize, nn::g3d::detail::Alignment_Default, AllocateType_EditObj);
        if (buffer == nullptr)
        {
            return false;
        }
    }

    m_pEditVertexShapeAnimArray = static_cast<EditShapeAnimObj::EditVertexShapeAnim*>(buffer);
    m_EditVertexShapeAnimCount = animCount;

    bool isFailed = false;
    for(int i = 0; i < m_EditVertexShapeAnimCount; ++i)
    {
        nn::g3d::ResVertexShapeAnim* resVertexShapeAnim = pResAnim->GetVertexShapeAnim(i);

        EditShapeAnimObj::EditVertexShapeAnim* editShapeAnim = new(&m_pEditVertexShapeAnimArray[i]) EditShapeAnimObj::EditVertexShapeAnim(m_pAllocator, resVertexShapeAnim);
        isFailed = !editShapeAnim->Init();
    }

    // 初期化失敗のものが一つでもあった場合は、インスタンスを破棄して失敗にする。
    if (isFailed)
    {
        DestroyDataForEditingAnimCurve();
        return false;
    }

    return true;
}

/*virtual*/void
EditShapeAnimObj::DestroyDataForEditingAnimCurve() NN_NOEXCEPT
{
    for(int i = 0; i < m_EditVertexShapeAnimCount; ++i)
    {
        EditShapeAnimObj::EditVertexShapeAnim* editVertexShapeAnim = &m_pEditVertexShapeAnimArray[i];
        editVertexShapeAnim->Destroy();
        editVertexShapeAnim->~EditVertexShapeAnim();
    }

    m_EditVertexShapeAnimCount = 0;

    if (m_pEditVertexShapeAnimArray != nullptr)
    {
        m_pAllocator->Free(m_pEditVertexShapeAnimArray);
        m_pEditVertexShapeAnimArray = nullptr;
    }
}

/*virtual*/BindResult
EditShapeAnimObj::SetupInternal(EditModelObj* pBindTargetEditModelObj, ModelAnimObj* pBoundAnimObj) NN_NOEXCEPT
{
    ShapeAnimObj* pAnimObj = static_cast<ShapeAnimObj*>(pBoundAnimObj);
    ResShapeAnim* pResAnim = static_cast<ResShapeAnim*>(GetResAnim());

    ShapeAnimObj::Builder builder;
    builder.SetContextDisabled();
    builder.Reserve(pBindTargetEditModelObj->GetResource());
    builder.Reserve(pResAnim);
    builder.CalculateMemorySize();
    size_t bufferSize = builder.GetWorkMemorySize();
    void* buffer = m_pAllocator->Allocate(bufferSize, ShapeAnimObj::Alignment_Buffer, AllocateType_Obj);
    NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(buffer, "%s\n", NN_G3D_VIEWER_RES_NAME(pBindTargetEditModelObj->GetResource(), GetName()));//今は止める
    bool success = builder.Build(pAnimObj, buffer, bufferSize);

    NN_G3D_VIEWER_ASSERT(success);
    pAnimObj->SetResource(pResAnim);
    BindResult result;
    result = pAnimObj->Bind(pBindTargetEditModelObj->GetResource());

    return result;
}

void
EditShapeAnimObj::EditCurve(
    int animIndex,
    int curveIndex,
    const nn::g3d::ResAnimCurve* resAnimCurve) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_DETAIL(curveIndex != -1, "%s\n", NN_G3D_VIEWER_RES_NAME(static_cast<ResShapeAnim*>(GetResAnim()), GetName()));

    if (animIndex >= m_EditVertexShapeAnimCount)
    {
        NN_G3D_VIEWER_ASSERT_INDEX_BOUNDS(animIndex, m_EditVertexShapeAnimCount);
        return;
    }

    EditShapeAnimObj::EditVertexShapeAnim* editVertexShapeAnim = &m_pEditVertexShapeAnimArray[animIndex];

    int curveCount = editVertexShapeAnim->GetEditAnimCurveCount();
    if (curveIndex >= curveCount)
    {
        NN_G3D_VIEWER_ASSERT_INDEX_BOUNDS(curveIndex, curveCount);
        return;
    }

    EditAnimCurve* editAnimCurve = editVertexShapeAnim->GetEditAnimCurve(curveIndex);
    editAnimCurve->Edit(resAnimCurve);
}

}}}}

