﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../g3d_ViewerDetailDefine.h"
#include "../util/g3d_EditWorkBuffer.h"

#include <nn/g3d/g3d_ResAnimCurve.h>

namespace nn { namespace g3d {
namespace viewer {
namespace detail {

class Allocator;

class EditAnimCurve
{
public:
    explicit EditAnimCurve(
        Allocator* pAllocator,
        nn::g3d::ResAnimCurve* pAnimCurve) NN_NOEXCEPT
        : m_pAnimCurve(pAnimCurve)
        , m_FrameArrayBuffer(pAllocator, AllocateType_DynamicBuffer)
        , m_KeyArrayBuffer(pAllocator, AllocateType_DynamicBuffer)
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(pAllocator);
        NN_G3D_VIEWER_ASSERT_NOT_NULL(pAnimCurve);
    }

    void Setup() NN_NOEXCEPT;
    void Cleanup() NN_NOEXCEPT;
    void Edit(const nn::g3d::ResAnimCurve* pResAnimCurveData) NN_NOEXCEPT;

private:
    nn::g3d::ResAnimCurve*         m_pAnimCurve;
    nn::g3d::ResAnimCurveData      m_OriginalAnimCurveData;
    EditWorkBuffer m_FrameArrayBuffer;
    EditWorkBuffer m_KeyArrayBuffer;
};

}}}}

