﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_EditAnimCurve.h"

#include "../g3d_Allocator.h"
#include "../util/g3d_ViewerUtility.h"
#include <nn/g3d/g3d_ResAnimCurve.h>

namespace nn { namespace g3d { namespace viewer { namespace detail {

void EditAnimCurve::Setup() NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(m_pAnimCurve);
    m_OriginalAnimCurveData = m_pAnimCurve->ToData();
}

void EditAnimCurve::Cleanup() NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(m_pAnimCurve);
    nn::g3d::ResAnimCurveData* resAnimCurveData = &m_pAnimCurve->ToData();

    resAnimCurveData->flag = m_OriginalAnimCurveData.flag;
    resAnimCurveData->keyCount = m_OriginalAnimCurveData.keyCount;
    resAnimCurveData->targetOffset = m_OriginalAnimCurveData.targetOffset;
    resAnimCurveData->startFrame = m_OriginalAnimCurveData.startFrame;
    resAnimCurveData->endFrame = m_OriginalAnimCurveData.endFrame;
    resAnimCurveData->iScale = m_OriginalAnimCurveData.iScale;
    resAnimCurveData->iOffset = m_OriginalAnimCurveData.iOffset;
    resAnimCurveData->fDelta = m_OriginalAnimCurveData.fDelta;
    resAnimCurveData->pFrameArray = m_OriginalAnimCurveData.pFrameArray;
    resAnimCurveData->pKeyArray = m_OriginalAnimCurveData.pKeyArray;
    m_FrameArrayBuffer.Clear();
    m_KeyArrayBuffer.Clear();
}

void EditAnimCurve::Edit(const nn::g3d::ResAnimCurve* pResAnimCurve) NN_NOEXCEPT
{
    NN_G3D_VIEWER_ASSERT_NOT_NULL(pResAnimCurve);
    NN_G3D_VIEWER_ASSERT_NOT_NULL(m_pAnimCurve);
    NN_G3D_VIEWER_ASSERT_DETAIL(
        pResAnimCurve->IsFloatCurve() == reinterpret_cast<nn::g3d::ResAnimCurve*>(&m_OriginalAnimCurveData)->IsFloatCurve(),
        "edit curve %d, original curve %d", pResAnimCurve->IsFloatCurve(), reinterpret_cast<nn::g3d::ResAnimCurve*>(&m_OriginalAnimCurveData)->IsFloatCurve());

    const nn::g3d::ResAnimCurveData* pResAnimCurveData = &pResAnimCurve->ToData();

    nn::g3d::ResAnimCurveData* targetAnimCurveData = &m_pAnimCurve->ToData();
    targetAnimCurveData->flag = pResAnimCurveData->flag;
    targetAnimCurveData->keyCount = pResAnimCurveData->keyCount;
    targetAnimCurveData->targetOffset = pResAnimCurveData->targetOffset;
    targetAnimCurveData->startFrame = pResAnimCurveData->startFrame;
    targetAnimCurveData->endFrame = pResAnimCurveData->endFrame;
    targetAnimCurveData->iScale = pResAnimCurveData->iScale;
    targetAnimCurveData->iOffset = pResAnimCurveData->iOffset;
    targetAnimCurveData->fDelta = pResAnimCurveData->fDelta;

    size_t frameArraySize = GetFrameArraySize(pResAnimCurveData);
    m_FrameArrayBuffer.Resize(frameArraySize);
    memcpy(m_FrameArrayBuffer.GetWorkBufferPtr(), pResAnimCurveData->pFrameArray.Get(), frameArraySize);
    targetAnimCurveData->pFrameArray.Set(m_FrameArrayBuffer.GetWorkBufferPtr());

    size_t keyArraySize = GetKeyArraySize(pResAnimCurveData);
    m_KeyArrayBuffer.Resize(keyArraySize);
    memcpy(m_KeyArrayBuffer.GetWorkBufferPtr(), pResAnimCurveData->pKeyArray.Get(), keyArraySize);
    targetAnimCurveData->pKeyArray.Set(m_KeyArrayBuffer.GetWorkBufferPtr());
}

}}}}

