﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_BitUtil.h>
#include <nn/g3d/detail/g3d_Flag.h>

namespace nn { namespace g3d  { namespace detail {

void FlagSet::Initialize(int flagCount, int flagSetCount, void* pBuffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(flagSetCount > 0 && flagSetCount <= sizeof(m_FlagPerSet) * 8);
    NN_SDK_REQUIRES(bufferSize >= CalcBufferSize(flagCount, flagSetCount));
    NN_UNUSED(bufferSize);

    m_FlagCount = flagCount;
    m_FlagSetCount = flagSetCount;
    m_Flag32Count = nn::util::align_up(flagCount, 32) >> 5;
    if (m_FlagCount > 0)
    {
        Bit32* ptr = static_cast<Bit32*>(pBuffer);
        m_pMainFlagArray = ptr;
        // フラグセットが1つの場合は、サブの指すポインターもマスターと同じにしておく
        if (m_FlagSetCount == 1)
        {
            m_pSubFlagArray = m_pMainFlagArray;
        }
        else
        {
            ptr += m_Flag32Count;
            m_pSubFlagArray = ptr;
        }
    }
    else
    {
        m_pMainFlagArray = NULL;
        m_pSubFlagArray = NULL;
    }
    m_MainFlag = 0;
    m_FlagPerSet = 0;
}

void FlagSet::Caclulate() NN_NOEXCEPT
{
    if (IsFlagDirty())
    {
        if (m_FlagSetCount > 1 && m_FlagCount > 0)
        {
            for (int idxFlag32 = 0; idxFlag32 < m_Flag32Count; ++idxFlag32)
            {
                Bit32 flag32 = m_pMainFlagArray[idxFlag32];
                // サブに伝搬させる
                for (int idxFlagSet = 0; idxFlagSet < m_FlagSetCount; ++idxFlagSet)
                {
                    m_pSubFlagArray[idxFlagSet * m_Flag32Count + idxFlag32] |= flag32;
                }
                // サブに情報が残っているので、マスターはクリア
                m_pMainFlagArray[idxFlag32] = 0;
            }
        }
        // 全セットに未参照のフラグを立てる
        m_FlagPerSet = Bit8(~0);
        // マスターのダーティフラグは落とす
        m_MainFlag &= ~Flag_Dirty;
    }
}

}}} // namespace nn::g3d::detail
