﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/font/font_Font.h>

//########################################


namespace nn {
namespace font {

void
TextureObject::Set(
    const void* pImage,
    TexFmt      format,
    uint16_t    width,
    uint16_t    height,
    uint8_t     sheetNum,
    bool        blackWhiteInterpolationEnabled
    )
{
    m_pImage        = pImage == NULL ? 0 : reinterpret_cast<uintptr_t>(pImage);

    m_Format        = format;
    m_Size.width    = width;
    m_Size.height   = height;

    m_SheetCount = sheetNum;
    m_ColorBlackWhiteInterpolationEnabled = blackWhiteInterpolationEnabled;
    m_isInitialized = true;
}

Font::Font()
: m_IsKerningEnabled(true)
, m_IsExtraMarginEnabled(true)
{
}

Font::~Font()
{
}

const CharStrmReader
Font::GetCharStrmReader(char /* dummy */) const
{
    CharStrmReader::ReadNextCharFunc pReadNextCharFunc = NULL;

    switch (GetCharacterCode())
    {
    case CharacterCode_Unicode:    pReadNextCharFunc = &CharStrmReader::ReadNextCharUtf8;   break;
    case CharacterCode_Sjis:       pReadNextCharFunc = &CharStrmReader::ReadNextCharSjis;   break;
    case CharacterCode_Cp1252:     pReadNextCharFunc = &CharStrmReader::ReadNextCharCp1252; break;

    default:
        NN_SDK_ASSERT(false);
        break;
    }

    return CharStrmReader(pReadNextCharFunc);
}

const CharStrmReader
Font::GetCharStrmReader(uint16_t /* dummy */) const
{
    CharStrmReader::ReadNextCharFunc pReadNextCharFunc = NULL;

    switch (GetCharacterCode())
    {
    case CharacterCode_Unicode:    pReadNextCharFunc = &CharStrmReader::ReadNextCharUtf16;  break;

    default:
        NN_SDK_ASSERT(false);
        break;
    }

    return CharStrmReader(pReadNextCharFunc);
}

}   // namespace font
}   // namespace nn
